package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolSpeciesRowModel.java 512 2013-03-01 20:37:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolSpeciesRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

/**
 * @author kmorin
 * @since 0.3
 */
public class EditProtocolSpeciesRowModel extends AbstractTuttiBeanUIModel<SpeciesProtocol, EditProtocolSpeciesRowModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPECIES_SURVEY_CODE = "speciesSurveyCode";

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_SIZE_ENABLED = "sizeEnabled";

    public static final String PROPERTY_SEX_ENABLED = "sexEnabled";

    public static final String PROPERTY_MATURITY_ENABLED = "maturityEnabled";

    public static final String PROPERTY_AGE_ENABLED = "ageEnabled";

    public static final String PROPERTY_LENGTH_STEP_PMFM = "lengthStepPmfm";

    public static final String PROPERTY_WEIGHT_ENABLED = "weightEnabled";

    public static final String PROPERTY_COUNT_IF_NO_FREQUENCY_ENABLED = "countIfNoFrequencyEnabled";

    public static final String PROPERTY_CALCIFY_SAMPLE_ENABLED = "calcifySampleEnabled";

    protected Species species;

    protected String speciesSurveyCode;

    protected boolean sizeEnabled;

    protected boolean sexEnabled;

    protected boolean maturityEnabled;

    protected boolean ageEnabled;

    protected Caracteristic lengthStepPmfm;

    protected boolean weightEnabled;

    protected boolean countIfNoFrequencyEnabled;

    protected boolean calcifySampleEnabled;

    protected static final Binder<SpeciesProtocol, EditProtocolSpeciesRowModel> fromBeanBinder =
            BinderFactory.newBinder(SpeciesProtocol.class,
                                    EditProtocolSpeciesRowModel.class);

    protected static final Binder<EditProtocolSpeciesRowModel, SpeciesProtocol> toBeanBinder =
            BinderFactory.newBinder(EditProtocolSpeciesRowModel.class,
                                    SpeciesProtocol.class);

    public EditProtocolSpeciesRowModel() {
        super(SpeciesProtocol.class, fromBeanBinder, toBeanBinder);
    }

    public Integer getSpeciesReferenceTaxonId() {
        return species.getReferenceTaxonId();
    }

    public Species getSpecies() {
        return species;
    }

    public void setSpecies(Species species) {
        Object oldValue = getSpecies();
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    public String getSpeciesSurveyCode() {
        return speciesSurveyCode;
    }

    public void setSpeciesSurveyCode(String speciesSurveyCode) {
        Object oldValue = getSpeciesSurveyCode();
        this.speciesSurveyCode = speciesSurveyCode;
        firePropertyChange(PROPERTY_SPECIES_SURVEY_CODE, oldValue, speciesSurveyCode);
    }

    public boolean isSizeEnabled() {
        return sizeEnabled;
    }

    public void setSizeEnabled(boolean sizeEnabled) {
        Object oldValue = isSizeEnabled();
        this.sizeEnabled = sizeEnabled;
        firePropertyChange(PROPERTY_SIZE_ENABLED, oldValue, sizeEnabled);
    }

    public boolean isSexEnabled() {
        return sexEnabled;
    }

    public void setSexEnabled(boolean sexEnabled) {
        Object oldValue = isSexEnabled();
        this.sexEnabled = sexEnabled;
        firePropertyChange(PROPERTY_SEX_ENABLED, oldValue, sexEnabled);
    }

    public boolean isMaturityEnabled() {
        return maturityEnabled;
    }

    public void setMaturityEnabled(boolean maturityEnabled) {
        Object oldValue = isMaturityEnabled();
        this.maturityEnabled = maturityEnabled;
        firePropertyChange(PROPERTY_MATURITY_ENABLED, oldValue, maturityEnabled);
    }

    public boolean isAgeEnabled() {
        return ageEnabled;
    }

    public void setAgeEnabled(boolean ageEnabled) {
        Object oldValue = isAgeEnabled();
        this.ageEnabled = ageEnabled;
        firePropertyChange(PROPERTY_AGE_ENABLED, oldValue, ageEnabled);
    }

    public String getLengthStepPmfmId() {
        return lengthStepPmfm != null ? lengthStepPmfm.getId() : null;
    }

    public Caracteristic getLengthStepPmfm() {
        return lengthStepPmfm;
    }

    public void setLengthStepPmfm(Caracteristic lengthStepPmfm) {
        Object oldValue = getLengthStepPmfm();
        this.lengthStepPmfm = lengthStepPmfm;
        firePropertyChange(PROPERTY_LENGTH_STEP_PMFM, oldValue, lengthStepPmfm);
    }

    public boolean isWeightEnabled() {
        return weightEnabled;
    }

    public void setWeightEnabled(boolean weightEnabled) {
        Object oldValue = isWeightEnabled();
        this.weightEnabled = weightEnabled;
        firePropertyChange(PROPERTY_WEIGHT_ENABLED, oldValue, weightEnabled);
    }

    public boolean isCountIfNoFrequencyEnabled() {
        return countIfNoFrequencyEnabled;
    }

    public void setCountIfNoFrequencyEnabled(boolean countIfNoFrequencyEnabled) {
        Object oldValue = isCountIfNoFrequencyEnabled();
        this.countIfNoFrequencyEnabled = countIfNoFrequencyEnabled;
        firePropertyChange(PROPERTY_COUNT_IF_NO_FREQUENCY_ENABLED, oldValue, countIfNoFrequencyEnabled);
    }

    public boolean isCalcifySampleEnabled() {
        return calcifySampleEnabled;
    }

    public void setCalcifySampleEnabled(boolean calcifySampleEnabled) {
        Object oldValue = isCalcifySampleEnabled();
        this.calcifySampleEnabled = calcifySampleEnabled;
        firePropertyChange(PROPERTY_CALCIFY_SAMPLE_ENABLED, oldValue, calcifySampleEnabled);
    }

}
