package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getWeightStringValue;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCatchesUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED = "catchesCaracteristicsAttachmentsButton.enabled";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN = "catchTotalRejectedWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL = "catchTotalRejectedWeightField.model";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalRejectedWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT = "catchTotalSortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "catchTotalUnsortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN = "catchTotalWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL = "catchTotalWeightField.model";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalWeightField.numberPattern";
    public static final String BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "speciesTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo accidentalTab;
    protected TabInfo benthosTab;
    protected Table benthosTable;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSampleSortedWeight",  editorName = "benthosTotalSampleSortedWeightField")
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected JTextField benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalUnsortedWeight",  editorName = "benthosTotalUnsortedWeightField")
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table catchTable;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalRejectedWeight",  editorName = "catchTotalRejectedWeightField")
    protected TuttiComputedOrNotDataEditor catchTotalRejectedWeightField;
    protected JLabel catchTotalRejectedWeightLabel;
    protected JTextField catchTotalSortedCarousselWeightField;
    protected JLabel catchTotalSortedCarousselWeightLabel;
    protected JTextField catchTotalSortedTremisWeightField;
    protected JLabel catchTotalSortedTremisWeightLabel;
    protected JTextField catchTotalSortedWeightField;
    protected JLabel catchTotalSortedWeightLabel;
    protected JPanel catchTotalSortedWeightPanel;
    protected CardLayout2Ext catchTotalSortedWeightPanelLayout;
    protected JTextField catchTotalUnsortedWeightField;
    protected JLabel catchTotalUnsortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalWeight",  editorName = "catchTotalWeightField")
    protected TuttiComputedOrNotDataEditor catchTotalWeightField;
    protected JLabel catchTotalWeightLabel;
    protected ButtonAttachment catchesCaracteristicsAttachmentsButton;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JScrollPane catchesCaracteristicsTabScrollPane;
    protected JToolBar catchesCaracteristicsTabToolBar;
    protected Table catchesForm;
    protected JButton computeSpeciesBatchButton;
    protected JPanel createFishingOperationActions;
    protected EditCatchesUI editCatchesTopPanel = this;
    protected EditCatchesUIHandler handler;
    protected JButton importPupitriButton;
    protected TabInfo macroWasteTab;
    protected Table macroWasteTable;
    @ValidatorField( validatorId = "validator",  propertyName = "macroWasteTotalWeight",  editorName = "macroWasteTotalWeightField")
    protected JTextField macroWasteTotalWeightField;
    protected JLabel macroWasteTotalWeightLabel;
    protected EditCatchesUIModel model;
    protected TabInfo observationIndividuelTab;
    protected TabInfo planktonTab;
    protected JButton saveButton;
    protected TabInfo speciesTab;
    protected SpeciesBatchUI speciesTabContent;
    protected CreateSpeciesBatchUI speciesTabCreateBatch;
    protected JXTitledPanel speciesTabCreateBatchReminderLabel;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected SpeciesFrequencyUI speciesTabFrequencyEditor;
    protected JXTitledPanel speciesTabFrequencyEditorReminderLabel;
    protected JPanel speciesTabPanel;
    protected CardLayout2Ext speciesTabPanelLayout;
    protected SplitSpeciesBatchUI speciesTabSplitBatch;
    protected JXTitledPanel speciesTabSplitBatchReminderLabel;
    protected Table speciesTable;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected JTextField speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JTabbedPane tabPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditCatchesUIHandler handler = new EditCatchesUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public Table getBenthosTable() {
        return benthosTable;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public JTextField getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getCatchTable() {
        return catchTable;
    }

    public TuttiComputedOrNotDataEditor getCatchTotalRejectedWeightField() {
        return catchTotalRejectedWeightField;
    }

    public JLabel getCatchTotalRejectedWeightLabel() {
        return catchTotalRejectedWeightLabel;
    }

    public JTextField getCatchTotalSortedCarousselWeightField() {
        return catchTotalSortedCarousselWeightField;
    }

    public JLabel getCatchTotalSortedCarousselWeightLabel() {
        return catchTotalSortedCarousselWeightLabel;
    }

    public JTextField getCatchTotalSortedTremisWeightField() {
        return catchTotalSortedTremisWeightField;
    }

    public JLabel getCatchTotalSortedTremisWeightLabel() {
        return catchTotalSortedTremisWeightLabel;
    }

    public JTextField getCatchTotalSortedWeightField() {
        return catchTotalSortedWeightField;
    }

    public JLabel getCatchTotalSortedWeightLabel() {
        return catchTotalSortedWeightLabel;
    }

    public JPanel getCatchTotalSortedWeightPanel() {
        return catchTotalSortedWeightPanel;
    }

    public CardLayout2Ext getCatchTotalSortedWeightPanelLayout() {
        return catchTotalSortedWeightPanelLayout;
    }

    public JTextField getCatchTotalUnsortedWeightField() {
        return catchTotalUnsortedWeightField;
    }

    public JLabel getCatchTotalUnsortedWeightLabel() {
        return catchTotalUnsortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getCatchTotalWeightField() {
        return catchTotalWeightField;
    }

    public JLabel getCatchTotalWeightLabel() {
        return catchTotalWeightLabel;
    }

    public ButtonAttachment getCatchesCaracteristicsAttachmentsButton() {
        return catchesCaracteristicsAttachmentsButton;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JScrollPane getCatchesCaracteristicsTabScrollPane() {
        return catchesCaracteristicsTabScrollPane;
    }

    public JToolBar getCatchesCaracteristicsTabToolBar() {
        return catchesCaracteristicsTabToolBar;
    }

    public Table getCatchesForm() {
        return catchesForm;
    }

    public JButton getComputeSpeciesBatchButton() {
        return computeSpeciesBatchButton;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public TabInfo getMacroWasteTab() {
        return macroWasteTab;
    }

    public Table getMacroWasteTable() {
        return macroWasteTable;
    }

    public JTextField getMacroWasteTotalWeightField() {
        return macroWasteTotalWeightField;
    }

    public JLabel getMacroWasteTotalWeightLabel() {
        return macroWasteTotalWeightLabel;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public TabInfo getObservationIndividuelTab() {
        return observationIndividuelTab;
    }

    public TabInfo getPlanktonTab() {
        return planktonTab;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public CreateSpeciesBatchUI getSpeciesTabCreateBatch() {
        return speciesTabCreateBatch;
    }

    public JXTitledPanel getSpeciesTabCreateBatchReminderLabel() {
        return speciesTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public SpeciesFrequencyUI getSpeciesTabFrequencyEditor() {
        return speciesTabFrequencyEditor;
    }

    public JXTitledPanel getSpeciesTabFrequencyEditorReminderLabel() {
        return speciesTabFrequencyEditorReminderLabel;
    }

    public JPanel getSpeciesTabPanel() {
        return speciesTabPanel;
    }

    public CardLayout2Ext getSpeciesTabPanelLayout() {
        return speciesTabPanelLayout;
    }

    public SplitSpeciesBatchUI getSpeciesTabSplitBatch() {
        return speciesTabSplitBatch;
    }

    public JXTitledPanel getSpeciesTabSplitBatchReminderLabel() {
        return speciesTabSplitBatchReminderLabel;
    }

    public Table getSpeciesTable() {
        return speciesTable;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public JTextField getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosTable() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTable.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSampleSortedWeightField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalUnsortedWeightField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchTable() {
        if (!allComponentsCreated) {
            return;
        }
        catchTable.add(catchTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalWeightField), new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightPanel, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightField, new GridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalRejectedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalRejectedWeightField), new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchTotalSortedWeightPanel() {
        if (!allComponentsCreated) {
            return;
        }
        catchTotalSortedWeightPanel.add(catchTotalSortedWeightField, EditCatchesUIHandler.CLASSIC_VESSEL);
        catchTotalSortedWeightPanel.add($Table0, EditCatchesUIHandler.CAROUSSEL_TREMIE_VESSEL);
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(catchesCaracteristicsTabScrollPane);
    }

    protected void addChildrenToCatchesCaracteristicsTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabScrollPane.getViewport().add($JPanel0);
    }

    protected void addChildrenToCatchesCaracteristicsTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabToolBar.add(importPupitriButton);
        catchesCaracteristicsTabToolBar.add(catchesCaracteristicsAttachmentsButton);
    }

    protected void addChildrenToCatchesForm() {
        if (!allComponentsCreated) {
            return;
        }
        catchesForm.add(catchTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(speciesTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(benthosTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(macroWasteTable, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
        createFishingOperationActions.add(computeSpeciesBatchButton);
    }

    protected void addChildrenToEditCatchesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(catchesCaracteristicsTabToolBar);
        add(tabPane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void addChildrenToMacroWasteTable() {
        if (!allComponentsCreated) {
            return;
        }
        macroWasteTable.add(macroWasteTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        macroWasteTable.add(SwingUtil.boxComponentWithJxLayer(macroWasteTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSpeciesTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabCreateBatchReminderLabel.add(speciesTabCreateBatch);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFrequencyEditorReminderLabel.add(speciesTabFrequencyEditor);
    }

    protected void addChildrenToSpeciesTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabPanel.add(speciesTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        speciesTabPanel.add(speciesTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        speciesTabPanel.add(speciesTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        speciesTabPanel.add(speciesTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToSpeciesTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabSplitBatchReminderLabel.add(speciesTabSplitBatch);
    }

    protected void addChildrenToSpeciesTable() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTable.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabPanel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.species"));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
        
        accidentalTab.setTitle(_("tutti.label.tab.accidentel"));
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
        
        benthosTab.setTitle(_("tutti.label.tab.benthos"));
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new Table());
        
        benthosTable.setName("benthosTable");
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightLabel.putClientProperty("italicStyle", true);
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new JTextField());
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setColumns(15);
        benthosTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalSortedWeight"));
        benthosTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalUnsortedWeight"));
        benthosTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(_("tutti.editCatchBatch.field.benthosTotalWeight"));
        benthosTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalWeight.help");
        benthosTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCatchBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.editCatchBatch.action.cancelEditCatchBatch"));
        cancelButton.setToolTipText(_("tutti.editCatchBatch.action.cancelEditCatchBatch.tip"));
        cancelButton.putClientProperty("help", "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        cancelButton.putClientProperty("tuttiAction", CancelEditCatchBatchAction.class);
    }

    protected void createCatchTable() {
        $objectMap.put("catchTable", catchTable = new Table());
        
        catchTable.setName("catchTable");
    }

    protected void createCatchTotalRejectedWeightField() {
        $objectMap.put("catchTotalRejectedWeightField", catchTotalRejectedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        catchTotalRejectedWeightField.setName("catchTotalRejectedWeightField");
        catchTotalRejectedWeightField.setDecimalNumber(3);
        catchTotalRejectedWeightField.setUseFloat(true);
        catchTotalRejectedWeightField.setShowReset(true);
    }

    protected void createCatchTotalRejectedWeightLabel() {
        $objectMap.put("catchTotalRejectedWeightLabel", catchTotalRejectedWeightLabel = new JLabel());
        
        catchTotalRejectedWeightLabel.setName("catchTotalRejectedWeightLabel");
        catchTotalRejectedWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalRejectedWeight"));
        catchTotalRejectedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
    }

    protected void createCatchTotalSortedCarousselWeightField() {
        $objectMap.put("catchTotalSortedCarousselWeightField", catchTotalSortedCarousselWeightField = new JTextField());
        
        catchTotalSortedCarousselWeightField.setName("catchTotalSortedCarousselWeightField");
        catchTotalSortedCarousselWeightField.setColumns(15);
        catchTotalSortedCarousselWeightField.setEnabled(false);
    }

    protected void createCatchTotalSortedCarousselWeightLabel() {
        $objectMap.put("catchTotalSortedCarousselWeightLabel", catchTotalSortedCarousselWeightLabel = new JLabel());
        
        catchTotalSortedCarousselWeightLabel.setName("catchTotalSortedCarousselWeightLabel");
        catchTotalSortedCarousselWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalSortedCarousselWeight"));
        catchTotalSortedCarousselWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
    }

    protected void createCatchTotalSortedTremisWeightField() {
        $objectMap.put("catchTotalSortedTremisWeightField", catchTotalSortedTremisWeightField = new JTextField());
        
        catchTotalSortedTremisWeightField.setName("catchTotalSortedTremisWeightField");
        catchTotalSortedTremisWeightField.setColumns(15);
        catchTotalSortedTremisWeightField.setEnabled(false);
    }

    protected void createCatchTotalSortedTremisWeightLabel() {
        $objectMap.put("catchTotalSortedTremisWeightLabel", catchTotalSortedTremisWeightLabel = new JLabel());
        
        catchTotalSortedTremisWeightLabel.setName("catchTotalSortedTremisWeightLabel");
        catchTotalSortedTremisWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalSortedTremisWeight"));
        catchTotalSortedTremisWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
    }

    protected void createCatchTotalSortedWeightField() {
        $objectMap.put("catchTotalSortedWeightField", catchTotalSortedWeightField = new JTextField());
        
        catchTotalSortedWeightField.setName("catchTotalSortedWeightField");
        catchTotalSortedWeightField.setColumns(15);
        catchTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalSortedWeightLabel() {
        $objectMap.put("catchTotalSortedWeightLabel", catchTotalSortedWeightLabel = new JLabel());
        
        catchTotalSortedWeightLabel.setName("catchTotalSortedWeightLabel");
        catchTotalSortedWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalSortedWeight"));
        catchTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
    }

    protected void createCatchTotalSortedWeightPanel() {
        $objectMap.put("catchTotalSortedWeightPanel", catchTotalSortedWeightPanel = new JPanel());
        
        catchTotalSortedWeightPanel.setName("catchTotalSortedWeightPanel");
        catchTotalSortedWeightPanel.setLayout(catchTotalSortedWeightPanelLayout);
    }

    protected void createCatchTotalSortedWeightPanelLayout() {
        $objectMap.put("catchTotalSortedWeightPanelLayout", catchTotalSortedWeightPanelLayout = new CardLayout2Ext(this, "catchTotalSortedWeightPanel"));
    }

    protected void createCatchTotalUnsortedWeightField() {
        $objectMap.put("catchTotalUnsortedWeightField", catchTotalUnsortedWeightField = new JTextField());
        
        catchTotalUnsortedWeightField.setName("catchTotalUnsortedWeightField");
        catchTotalUnsortedWeightField.setColumns(15);
        catchTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalUnsortedWeightLabel() {
        $objectMap.put("catchTotalUnsortedWeightLabel", catchTotalUnsortedWeightLabel = new JLabel());
        
        catchTotalUnsortedWeightLabel.setName("catchTotalUnsortedWeightLabel");
        catchTotalUnsortedWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalUnsortedWeight"));
        catchTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
    }

    protected void createCatchTotalWeightField() {
        $objectMap.put("catchTotalWeightField", catchTotalWeightField = new TuttiComputedOrNotDataEditor(this));
        
        catchTotalWeightField.setName("catchTotalWeightField");
        catchTotalWeightField.setDecimalNumber(3);
        catchTotalWeightField.setUseFloat(true);
        catchTotalWeightField.setShowReset(true);
    }

    protected void createCatchTotalWeightLabel() {
        $objectMap.put("catchTotalWeightLabel", catchTotalWeightLabel = new JLabel());
        
        catchTotalWeightLabel.setName("catchTotalWeightLabel");
        catchTotalWeightLabel.setText(_("tutti.editCatchBatch.field.catchTotalWeight"));
        catchTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalWeight.help");
        catchTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createCatchesCaracteristicsAttachmentsButton() {
        $objectMap.put("catchesCaracteristicsAttachmentsButton", catchesCaracteristicsAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        catchesCaracteristicsAttachmentsButton.setName("catchesCaracteristicsAttachmentsButton");
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabScrollPane() {
        $objectMap.put("catchesCaracteristicsTabScrollPane", catchesCaracteristicsTabScrollPane = new JScrollPane());
        
        catchesCaracteristicsTabScrollPane.setName("catchesCaracteristicsTabScrollPane");
    }

    protected void createCatchesCaracteristicsTabToolBar() {
        $objectMap.put("catchesCaracteristicsTabToolBar", catchesCaracteristicsTabToolBar = new JToolBar());
        
        catchesCaracteristicsTabToolBar.setName("catchesCaracteristicsTabToolBar");
        catchesCaracteristicsTabToolBar.setFloatable(false);
        catchesCaracteristicsTabToolBar.setOpaque(false);
        catchesCaracteristicsTabToolBar.setBorderPainted(false);
    }

    protected void createCatchesForm() {
        $objectMap.put("catchesForm", catchesForm = new Table());
        
        catchesForm.setName("catchesForm");
    }

    protected void createComputeSpeciesBatchButton() {
        $objectMap.put("computeSpeciesBatchButton", computeSpeciesBatchButton = new JButton());
        
        computeSpeciesBatchButton.setName("computeSpeciesBatchButton");
        computeSpeciesBatchButton.setText(_("tutti.editCatchBatch.action.computeWeights"));
        computeSpeciesBatchButton.setToolTipText(_("tutti.editCatchBatch.action.computeWeights.tip"));
        computeSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.computeWeights.help");
        computeSpeciesBatchButton.putClientProperty("tuttiAction", ComputeWeightsAction.class);
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCatchesUIHandler.class));
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(_("tutti.editCatchBatch.action.importPupitri"));
        importPupitriButton.setToolTipText(_("tutti.editCatchBatch.action.importPupitri.tip"));
        importPupitriButton.putClientProperty("help", "tutti.editCatchBatch.action.importPupitri.help");
        importPupitriButton.putClientProperty("tuttiAction", ImportPupitriAction.class);
    }

    protected void createMacroWasteTab() {
        $objectMap.put("macroWasteTab", macroWasteTab = new TabInfo());
        
        macroWasteTab.setTitle(_("tutti.label.tab.macroDechet"));
    }

    protected void createMacroWasteTable() {
        $objectMap.put("macroWasteTable", macroWasteTable = new Table());
        
        macroWasteTable.setName("macroWasteTable");
    }

    protected void createMacroWasteTotalWeightField() {
        $objectMap.put("macroWasteTotalWeightField", macroWasteTotalWeightField = new JTextField());
        
        macroWasteTotalWeightField.setName("macroWasteTotalWeightField");
        macroWasteTotalWeightField.setColumns(15);
        macroWasteTotalWeightField.putClientProperty("computed", true);
    }

    protected void createMacroWasteTotalWeightLabel() {
        $objectMap.put("macroWasteTotalWeightLabel", macroWasteTotalWeightLabel = new JLabel());
        
        macroWasteTotalWeightLabel.setName("macroWasteTotalWeightLabel");
        macroWasteTotalWeightLabel.setText(_("tutti.editCatchBatch.field.macroWasteTotalWeight"));
        macroWasteTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.macroWasteTotalWeight.help");
        macroWasteTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createObservationIndividuelTab() {
        $objectMap.put("observationIndividuelTab", observationIndividuelTab = new TabInfo());
        
        observationIndividuelTab.setTitle(_("tutti.label.tab.observationIndividuel"));
    }

    protected void createPlanktonTab() {
        $objectMap.put("planktonTab", planktonTab = new TabInfo());
        
        planktonTab.setTitle(_("tutti.label.tab.plancton"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editCatchBatch.action.saveCatchBatch"));
        saveButton.setToolTipText(_("tutti.editCatchBatch.action.saveCatchBatch.tip"));
        saveButton.putClientProperty("help", "tutti.editCatchBatch.action.saveCatchBatch.help");
        saveButton.putClientProperty("tuttiAction", SaveCatchBatchAction.class);
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
        
        speciesTab.setTitle(_("tutti.label.tab.species"));
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabCreateBatch() {
        $objectMap.put("speciesTabCreateBatch", speciesTabCreateBatch = new CreateSpeciesBatchUI(this));
        
        speciesTabCreateBatch.setName("speciesTabCreateBatch");
    }

    protected void createSpeciesTabCreateBatchReminderLabel() {
        $objectMap.put("speciesTabCreateBatchReminderLabel", speciesTabCreateBatchReminderLabel = new JXTitledPanel());
        
        speciesTabCreateBatchReminderLabel.setName("speciesTabCreateBatchReminderLabel");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTabFrequencyEditor() {
        $objectMap.put("speciesTabFrequencyEditor", speciesTabFrequencyEditor = new SpeciesFrequencyUI(speciesTabContent));
        
        speciesTabFrequencyEditor.setName("speciesTabFrequencyEditor");
    }

    protected void createSpeciesTabFrequencyEditorReminderLabel() {
        $objectMap.put("speciesTabFrequencyEditorReminderLabel", speciesTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        speciesTabFrequencyEditorReminderLabel.setName("speciesTabFrequencyEditorReminderLabel");
    }

    protected void createSpeciesTabPanel() {
        $objectMap.put("speciesTabPanel", speciesTabPanel = new JPanel());
        
        speciesTabPanel.setName("speciesTabPanel");
        speciesTabPanel.setLayout(speciesTabPanelLayout);
    }

    protected void createSpeciesTabPanelLayout() {
        $objectMap.put("speciesTabPanelLayout", speciesTabPanelLayout = new CardLayout2Ext(this, "speciesTabPanel"));
    }

    protected void createSpeciesTabSplitBatch() {
        $objectMap.put("speciesTabSplitBatch", speciesTabSplitBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabSplitBatch.setName("speciesTabSplitBatch");
    }

    protected void createSpeciesTabSplitBatchReminderLabel() {
        $objectMap.put("speciesTabSplitBatchReminderLabel", speciesTabSplitBatchReminderLabel = new JXTitledPanel());
        
        speciesTabSplitBatchReminderLabel.setName("speciesTabSplitBatchReminderLabel");
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new Table());
        
        speciesTable.setName("speciesTable");
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightLabel.putClientProperty("italicStyle", true);
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new JTextField());
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setColumns(15);
        speciesTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalSortedWeight"));
        speciesTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalUnsortedWeight"));
        speciesTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.editCatchBatch.field.speciesTotalWeight"));
        speciesTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalWeight.help");
        speciesTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCatchesTopPanel();
        addChildrenToValidator();
        addChildrenToCatchesCaracteristicsTabToolBar();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToCatchesCaracteristicsTabScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(catchesForm, BorderLayout.NORTH);
        addChildrenToCatchesForm();
        addChildrenToCatchTable();
        addChildrenToCatchTotalSortedWeightPanel();
        // inline complete setup of $Table0
        $Table0.add(catchTotalSortedCarousselWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(catchTotalSortedCarousselWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(catchTotalSortedTremisWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(catchTotalSortedTremisWeightField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSpeciesTable();
        addChildrenToBenthosTable();
        addChildrenToMacroWasteTable();
        addChildrenToSpeciesTabPanel();
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToSpeciesTabCreateBatchReminderLabel();
        addChildrenToSpeciesTabSplitBatchReminderLabel();
        addChildrenToSpeciesTabFrequencyEditorReminderLabel();
        // inline complete setup of $JPanel1
        $JPanel1.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 60 property setters
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        importPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.importPupitri.mnemonic"),'Z'));
        catchesCaracteristicsTabPane.setRightDecoration(catchesCaracteristicsTabToolBar);
        catchTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.total")));
        catchTotalWeightLabel.setLabelFor(catchTotalWeightField);
        catchTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalWeight.tip"));
        catchTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        catchTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedWeightLabel.setLabelFor(catchTotalSortedWeightField);
        catchTotalSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalSortedWeight.tip"));
        catchTotalSortedCarousselWeightLabel.setLabelFor(catchTotalSortedCarousselWeightField);
        catchTotalSortedCarousselWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.tip"));
        catchTotalSortedTremisWeightLabel.setLabelFor(catchTotalSortedTremisWeightField);
        catchTotalSortedTremisWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalSortedTremisWeight.tip"));
        catchTotalUnsortedWeightLabel.setLabelFor(catchTotalUnsortedWeightField);
        catchTotalUnsortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalUnsortedWeight.tip"));
        catchTotalRejectedWeightLabel.setLabelFor(catchTotalRejectedWeightField);
        catchTotalRejectedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.catchTotalRejectedWeight.tip"));
        catchTotalRejectedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalRejectedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        catchTotalRejectedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.species")));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalWeight.tip"));
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalSortedWeight.tip"));
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalSampleSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.tip"));
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalUnsortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.speciesTotalUnsortedWeight.tip"));
        benthosTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.benthos")));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalWeight.tip"));
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalSortedWeight.tip"));
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalSampleSortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.tip"));
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        benthosTotalUnsortedWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.benthosTotalUnsortedWeight.tip"));
        macroWasteTable.setBorder(BorderFactory.createTitledBorder(_("tutti.editCatchBatch.legend.macroWaste")));
        macroWasteTotalWeightLabel.setLabelFor(macroWasteTotalWeightField);
        macroWasteTotalWeightLabel.setToolTipText(_("tutti.editCatchBatch.field.macroWasteTotalWeight.tip"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.cancelEditCatchBatch.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.saveCatchBatch.mnemonic"),'Z'));
        computeSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("generate"));
        computeSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCatchBatch.action.computeWeights.mnemonic"),'Z'));
        benthosTab.setEnabled(false);
        planktonTab.setEnabled(false);
        macroWasteTab.setEnabled(false);
        accidentalTab.setEnabled(false);
        observationIndividuelTab.setEnabled(false);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCatchesTopPanel, "tutti.editCatchBatch.help");
        registerHelpId(_broker, importPupitriButton, "tutti.editCatchBatch.action.importPupitri.help");
        registerHelpId(_broker, catchTotalWeightLabel, "tutti.editCatchBatch.field.catchTotalWeight.help");
        registerHelpId(_broker, catchTotalSortedWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
        registerHelpId(_broker, catchTotalSortedCarousselWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
        registerHelpId(_broker, catchTotalSortedTremisWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
        registerHelpId(_broker, catchTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
        registerHelpId(_broker, catchTotalRejectedWeightLabel, "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
        registerHelpId(_broker, speciesTotalWeightLabel, "tutti.editCatchBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalWeightLabel, "tutti.editCatchBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, macroWasteTotalWeightLabel, "tutti.editCatchBatch.field.macroWasteTotalWeight.help");
        registerHelpId(_broker, cancelButton, "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        registerHelpId(_broker, saveButton, "tutti.editCatchBatch.action.saveCatchBatch.help");
        registerHelpId(_broker, computeSpeciesBatchButton, "tutti.editCatchBatch.action.computeWeights.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editCatchesTopPanel", editCatchesTopPanel);
        createHandler();
        createModel();
        createValidator();
        createSpeciesTabPanelLayout();
        createCatchTotalSortedWeightPanelLayout();
        createBroker();
        createCatchesCaracteristicsTabToolBar();
        createImportPupitriButton();
        createCatchesCaracteristicsAttachmentsButton();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createCatchesCaracteristicsTabScrollPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCatchesForm();
        createCatchTable();
        createCatchTotalWeightLabel();
        createCatchTotalWeightField();
        createCatchTotalSortedWeightLabel();
        createCatchTotalSortedWeightPanel();
        createCatchTotalSortedWeightField();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createCatchTotalSortedCarousselWeightLabel();
        createCatchTotalSortedCarousselWeightField();
        createCatchTotalSortedTremisWeightLabel();
        createCatchTotalSortedTremisWeightField();
        createCatchTotalUnsortedWeightLabel();
        createCatchTotalUnsortedWeightField();
        createCatchTotalRejectedWeightLabel();
        createCatchTotalRejectedWeightField();
        createSpeciesTable();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createBenthosTable();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createMacroWasteTable();
        createMacroWasteTotalWeightLabel();
        createMacroWasteTotalWeightField();
        createSpeciesTabPanel();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createSpeciesTabCreateBatchReminderLabel();
        createSpeciesTabCreateBatch();
        createSpeciesTabSplitBatchReminderLabel();
        createSpeciesTabSplitBatch();
        createSpeciesTabFrequencyEditorReminderLabel();
        createSpeciesTabFrequencyEditor();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createComputeSpeciesBatchButton();
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createPlanktonTab();
        createMacroWasteTab();
        createAccidentalTab();
        createObservationIndividuelTab();
        // inline creation of editCatchesTopPanel
        setName("editCatchesTopPanel");
        setLayout(new BorderLayout());
        editCatchesTopPanel.putClientProperty("help", "tutti.editCatchBatch.help");
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesCaracteristicsAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setModel(model.getCatchTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setBean(model.getCatchTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedWeightField, getWeightStringValue(model.getCatchTotalSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalUnsortedWeightField, getWeightStringValue(model.getCatchTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setModel(model.getCatchTotalRejectedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setBean(model.getCatchTotalRejectedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalRejectedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, getWeightStringValue(model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSortedWeightField, model.getSpeciesTotalSortedWeight() != null ?
                                getStringValue(model.getSpeciesTotalSortedWeight()) :
                                getWeightStringValue(model.getSpeciesTotalSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, getWeightStringValue(model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getWeightStringValue(model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.addPropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabFishingOperationReminderLabel.setRightDecoration(speciesTabContent.getSpeciesBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.removePropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        });
    }

}