/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.util.ArrayList;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TerracottaClusteredInstanceHelper {
    private static final boolean TC_DSO_MODE = Boolean.getBoolean("tc.active");
    private static final String ENTERPRISE_EXPRESS_FACTORY = "net.sf.ehcache.terracotta.ExpressEnterpriseTerracottaClusteredInstanceFactory";
    private static final String ENTERPRISE_CUSTOM_FACTORY = "org.terracotta.modules.ehcache.store.EnterpriseTerracottaClusteredInstanceFactory";
    private static final String EXPRESS_FACTORY = "net.sf.ehcache.terracotta.StandaloneTerracottaClusteredInstanceFactory";
    private static final String CUSTOM_FACTORY = "org.terracotta.modules.ehcache.store.TerracottaClusteredInstanceFactory";
    private static volatile TerracottaRuntimeType terracottaRuntimeType;

    TerracottaClusteredInstanceHelper() {
    }

    private static void lookupTerracottaRuntime() {
        if (terracottaRuntimeType == null) {
            TerracottaRuntimeType[] lookupSequence;
            for (TerracottaRuntimeType type : lookupSequence = new TerracottaRuntimeType[]{TerracottaRuntimeType.EnterpriseExpress, TerracottaRuntimeType.EnterpriseCustom, TerracottaRuntimeType.Express, TerracottaRuntimeType.Custom}) {
                if (type.getFactoryClassOrNull() == null) continue;
                terracottaRuntimeType = type;
                break;
            }
        }
    }

    static ClusteredInstanceFactory newClusteredInstanceFactory(Map<String, CacheConfiguration> cacheConfigs, TerracottaClientConfiguration terracottaConfig) {
        TerracottaClusteredInstanceHelper.lookupTerracottaRuntime();
        if (terracottaRuntimeType == null) {
            throw new CacheException("Terracotta cache classes are not available, you are missing jar(s) most likely");
        }
        if (terracottaRuntimeType == TerracottaRuntimeType.EnterpriseExpress || terracottaRuntimeType == TerracottaRuntimeType.Express) {
            TerracottaClusteredInstanceHelper.assertExpress(cacheConfigs, terracottaConfig);
        } else if (terracottaRuntimeType == TerracottaRuntimeType.EnterpriseCustom || terracottaRuntimeType == TerracottaRuntimeType.Custom) {
            TerracottaClusteredInstanceHelper.assertCustom(terracottaConfig);
        } else {
            throw new CacheException("Unknown Terracotta runtime type - " + (Object)((Object)terracottaRuntimeType));
        }
        Class factoryClass = terracottaRuntimeType.getFactoryClassOrNull();
        if (factoryClass == null) {
            throw new CacheException("Not able to get factory class for: " + terracottaRuntimeType.name());
        }
        return (ClusteredInstanceFactory)ClassLoaderUtil.createNewInstance(factoryClass.getName(), new Class[]{TerracottaClientConfiguration.class}, new Object[]{terracottaConfig});
    }

    private static void assertCustom(TerracottaClientConfiguration terracottaConfig) {
        if (!TC_DSO_MODE) {
            throw new CacheException("When not using standalone deployment, you need to use full install of Terracotta in order to use Terracotta Clustered Caches.");
        }
        if (terracottaConfig != null) {
            throw new CacheException("The ehcache configuration specified Terracotta configuration information, but when using the full install of Terracotta, you must specify the Terracotta configuration only with an external tc-config.xml file, not embedded or referenced from the ehcache configuration file.");
        }
    }

    private static void assertExpress(Map<String, CacheConfiguration> cacheConfigs, TerracottaClientConfiguration terracottaConfig) {
        ArrayList<String> identityCaches = new ArrayList<String>();
        for (CacheConfiguration config : cacheConfigs.values()) {
            TerracottaConfiguration tcConfig = config.getTerracottaConfiguration();
            if (tcConfig == null || tcConfig.getValueMode() != TerracottaConfiguration.ValueMode.IDENTITY) continue;
            identityCaches.add(config.getName());
        }
        if (!identityCaches.isEmpty()) {
            throw new CacheException("One or more caches are configured for identity value mode which is not permitted with standalone deployment " + ((Object)identityCaches).toString());
        }
        if (terracottaConfig == null) {
            throw new CacheException("Terracotta caches are defined but no <terracottaConfig> element was used to specify the Terracotta configuration.");
        }
    }

    static TerracottaConfiguration.StorageStrategy getDefaultStorageStrategyForCurrentRuntime() {
        TerracottaClusteredInstanceHelper.lookupTerracottaRuntime();
        if (terracottaRuntimeType == null) {
            throw new CacheException("Terracotta cache classes are not available, you are missing jar(s) most likely");
        }
        switch (terracottaRuntimeType) {
            case Express: 
            case Custom: {
                return TerracottaConfiguration.StorageStrategy.CLASSIC;
            }
            case EnterpriseCustom: 
            case EnterpriseExpress: {
                return TerracottaConfiguration.StorageStrategy.DCV2;
            }
        }
        throw new CacheException("Unknown Terracotta runtime type - " + (Object)((Object)terracottaRuntimeType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TerracottaRuntimeType {
        EnterpriseExpress("net.sf.ehcache.terracotta.ExpressEnterpriseTerracottaClusteredInstanceFactory"),
        Express("net.sf.ehcache.terracotta.StandaloneTerracottaClusteredInstanceFactory"),
        EnterpriseCustom("org.terracotta.modules.ehcache.store.EnterpriseTerracottaClusteredInstanceFactory"),
        Custom("org.terracotta.modules.ehcache.store.TerracottaClusteredInstanceFactory");

        private final String factoryClassName;

        private TerracottaRuntimeType(String factoryClassName) {
            this.factoryClassName = factoryClassName;
        }

        public Class getFactoryClassOrNull() {
            try {
                return ClassLoaderUtil.loadClass(this.factoryClassName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }
}

