/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorScope;

public class SwingValidatorMessageTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel rendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ImageIcon icon = null;
        String text = null;
        String toolTipText = null;
        column = table.convertColumnIndexToModel(column);
        if (table.getRowSorter() != null) {
            row = table.getRowSorter().convertRowIndexToModel(row);
        }
        switch (column) {
            case 0: {
                NuitonValidatorScope scope = (NuitonValidatorScope)value;
                icon = SwingValidatorUtil.getIcon(scope);
                String label = I18n._((String)scope.getLabel(), (Object[])new Object[0]);
                toolTipText = I18n._((String)"validator.scope.tip", (Object[])new Object[]{label});
                break;
            }
            case 1: {
                text = this.getFieldName(table, (String)value, row);
                toolTipText = I18n._((String)"validator.field.tip", (Object[])new Object[]{text});
                break;
            }
            case 2: {
                text = this.getMessage(table, (String)value, row);
                toolTipText = I18n._((String)"validator.message.tip", (Object[])new Object[]{text});
            }
        }
        rendererComponent.setText(text);
        rendererComponent.setToolTipText(toolTipText);
        rendererComponent.setIcon(icon);
        return rendererComponent;
    }

    public ImageIcon getIcon(NuitonValidatorScope scope) {
        ImageIcon icon = SwingValidatorUtil.getIcon(scope);
        return icon;
    }

    public String getMessage(JTable table, String value, int row) {
        SwingValidatorMessageTableModel tableModel = (SwingValidatorMessageTableModel)table.getModel();
        SwingValidatorMessage model = tableModel.getRow(row);
        String text = SwingValidatorUtil.getMessage(model);
        return text;
    }

    public String getFieldName(JTable table, String value, int row) {
        SwingValidatorMessageTableModel tableModel = (SwingValidatorMessageTableModel)table.getModel();
        SwingValidatorMessage model = tableModel.getRow(row);
        String fieldName = SwingValidatorUtil.getFieldName(model, value);
        return fieldName;
    }
}

