package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesFrequencyUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SpeciesFrequencyUIModel, SpeciesFrequencyUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_DATA_FIELD_LAYOUT_SELECTED = "dataFieldLayout.selected";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED = "lengthStepCaracteristicComboBox.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "lengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED = "lengthStepCaracteristicLabel.enabled";
    public static final String BINDING_MAX_STEP_FIELD_MODEL = "maxStepField.model";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_PATTERN = "maxStepField.numberPattern";
    public static final String BINDING_MIN_STEP_FIELD_MODEL = "minStepField.model";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_PATTERN = "minStepField.numberPattern";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_RAFALE_STEP_FIELD_ENABLED = "rafaleStepField.enabled";
    public static final String BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN = "rafaleStepField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SIMPLE_COUNTING_FIELD_MODEL = "simpleCountingField.model";
    public static final String BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED = "simpleCountingModeButton.selected";
    public static final String BINDING_SIMPLE_MODE_BUTTON_SELECTED = "simpleModeButton.selected";
    public static final String BINDING_STEP_FIELD_ENABLED = "stepField.enabled";
    public static final String BINDING_STEP_FIELD_MODEL = "stepField.model";
    public static final String BINDING_STEP_FIELD_NUMBER_PATTERN = "stepField.numberPattern";
    public static final String BINDING_STEP_LABEL_ENABLED = "stepLabel.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected JPanel configurationPanel;
    protected CardLayout2Ext dataFieldLayout;
    protected JPanel dataFieldPanel;
    protected SpeciesFrequencyUI editSpeciesFrequenciesTopPanel = this;
    protected JButton generateButton;
    protected SpeciesFrequencyUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "lengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> lengthStepCaracteristicComboBox;
    protected JLabel lengthStepCaracteristicLabel;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected SpeciesFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected JButton saveButton;
    protected NumberEditor simpleCountingField;
    protected JLabel simpleCountingLabel;
    protected JRadioButton simpleCountingModeButton;
    protected JLabel simpleCountingModeLabel;
    protected JPanel simpleCountingModePanel;
    protected JRadioButton simpleModeButton;
    protected JLabel simpleModeLabel;
    protected JPanel simpleModePanel;
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    @ValidatorField( validatorId = "validator",  propertyName = "rows",  editorName = "tableScrollPane")
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesFrequencyUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesFrequencyUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  SpeciesFrequencyUIHandler handler = new SpeciesFrequencyUIHandler(parentUI.getHandler().getContext(), this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public SpeciesFrequencyUI() {
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__generateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateLengthSteps();
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doActionPerformed__on__simpleCountingModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE_COUNTING);
    }

    public void doActionPerformed__on__simpleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public CardLayout2Ext getDataFieldLayout() {
        return dataFieldLayout;
    }

    public JPanel getDataFieldPanel() {
        return dataFieldPanel;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public SpeciesFrequencyUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<Caracteristic> getLengthStepCaracteristicComboBox() {
        return lengthStepCaracteristicComboBox;
    }

    public JLabel getLengthStepCaracteristicLabel() {
        return lengthStepCaracteristicLabel;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public SpeciesFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public NumberEditor getSimpleCountingField() {
        return simpleCountingField;
    }

    public JLabel getSimpleCountingLabel() {
        return simpleCountingLabel;
    }

    public JRadioButton getSimpleCountingModeButton() {
        return simpleCountingModeButton;
    }

    public JLabel getSimpleCountingModeLabel() {
        return simpleCountingModeLabel;
    }

    public JPanel getSimpleCountingModePanel() {
        return simpleCountingModePanel;
    }

    public JRadioButton getSimpleModeButton() {
        return simpleModeButton;
    }

    public JLabel getSimpleModeLabel() {
        return simpleModeLabel;
    }

    public JPanel getSimpleModePanel() {
        return simpleModePanel;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add($JPanel0, BorderLayout.CENTER);
        configurationPanel.add($Table2, BorderLayout.SOUTH);
    }

    protected void addChildrenToDataFieldPanel() {
        if (!allComponentsCreated) {
            return;
        }
        dataFieldPanel.add(SwingUtil.boxComponentWithJxLayer(tableScrollPane), "lengthCaracteristicPmfm");
        dataFieldPanel.add($Table3, "noLengthCaracteristicPmfm");
    }

    protected void addChildrenToEditSpeciesFrequenciesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(dataFieldPanel, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(simpleModePanel, "simpleMode");
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
        modeConfigurationPanel.add(simpleCountingModePanel, "simpleCountingMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(simpleModeButton);
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
        modePanel.add(simpleCountingModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToSimpleCountingModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleCountingModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleCountingModeButton); }
    }

    protected void addChildrenToSimpleCountingModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleCountingModePanel.add(simpleCountingModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToSimpleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleModeButton); }
    }

    protected void addChildrenToSimpleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleModePanel.add(simpleModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(_("tutti.label.frequencyConfiguration.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editSpeciesFrequencies.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createDataFieldLayout() {
        $objectMap.put("dataFieldLayout", dataFieldLayout = new CardLayout2Ext(this, "dataFieldPanel"));
    }

    protected void createDataFieldPanel() {
        $objectMap.put("dataFieldPanel", dataFieldPanel = new JPanel());
        
        dataFieldPanel.setName("dataFieldPanel");
        dataFieldPanel.setLayout(dataFieldLayout);
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(_("tutti.action.generate"));
        generateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesFrequencyUIHandler.class));
    }

    protected void createLengthStepCaracteristicComboBox() {
        $objectMap.put("lengthStepCaracteristicComboBox", lengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        lengthStepCaracteristicComboBox.setName("lengthStepCaracteristicComboBox");
        lengthStepCaracteristicComboBox.setI18nPrefix("tutti.property.");
        lengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        lengthStepCaracteristicComboBox.setShowReset(true);
    }

    protected void createLengthStepCaracteristicLabel() {
        $objectMap.put("lengthStepCaracteristicLabel", lengthStepCaracteristicLabel = new JLabel());
        
        lengthStepCaracteristicLabel.setName("lengthStepCaracteristicLabel");
        lengthStepCaracteristicLabel.setText(_("tutti.label.frequencyConfiguration.lengthStepCaracteristic"));
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setUseFloat(true);
        maxStepField.setShowReset(true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(_("tutti.label.frequencyConfiguration.maxStep"));
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setUseFloat(true);
        minStepField.setShowReset(true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(_("tutti.label.frequencyConfiguration.minStep"));
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(_("tutti.label.frequencyConfiguration.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setUseFloat(true);
        rafaleStepField.setShowReset(true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(_("tutti.label.frequencyConfiguration.rafaleStep"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.setMnemonic(83);
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSimpleCountingField() {
        $objectMap.put("simpleCountingField", simpleCountingField = new NumberEditor(this));
        
        simpleCountingField.setName("simpleCountingField");
        simpleCountingField.setProperty("simpleCount");
        simpleCountingField.setUseFloat(false);
        simpleCountingField.setShowReset(true);
    }

    protected void createSimpleCountingLabel() {
        $objectMap.put("simpleCountingLabel", simpleCountingLabel = new JLabel());
        
        simpleCountingLabel.setName("simpleCountingLabel");
        simpleCountingLabel.setText(_("tutti.table.species.frequency.header.number"));
    }

    protected void createSimpleCountingModeButton() {
        $objectMap.put("simpleCountingModeButton", simpleCountingModeButton = new JRadioButton());
        
        simpleCountingModeButton.setName("simpleCountingModeButton");
        simpleCountingModeButton.setText(_("tutti.label.frequencyConfiguration.mode.simpleCounting"));
        { simpleCountingModeButton.putClientProperty("$value", "simpleCountingMode");  Object $buttonGroup = simpleCountingModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleCountingModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.simpleCounting.tip"));
        simpleCountingModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleCountingModeButton"));
    }

    protected void createSimpleCountingModeLabel() {
        $objectMap.put("simpleCountingModeLabel", simpleCountingModeLabel = new JLabel());
        
        simpleCountingModeLabel.setName("simpleCountingModeLabel");
        simpleCountingModeLabel.setEnabled(false);
        simpleCountingModeLabel.setText(_("tutti.label.frequencyConfiguration.no.configuration"));
    }

    protected void createSimpleCountingModePanel() {
        $objectMap.put("simpleCountingModePanel", simpleCountingModePanel = new JPanel());
        
        simpleCountingModePanel.setName("simpleCountingModePanel");
        simpleCountingModePanel.setLayout(new BorderLayout());
    }

    protected void createSimpleModeButton() {
        $objectMap.put("simpleModeButton", simpleModeButton = new JRadioButton());
        
        simpleModeButton.setName("simpleModeButton");
        simpleModeButton.setText(_("tutti.label.frequencyConfiguration.mode.simple"));
        { simpleModeButton.putClientProperty("$value", "simpleMode");  Object $buttonGroup = simpleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.simple.tip"));
        simpleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleModeButton"));
    }

    protected void createSimpleModeLabel() {
        $objectMap.put("simpleModeLabel", simpleModeLabel = new JLabel());
        
        simpleModeLabel.setName("simpleModeLabel");
        simpleModeLabel.setEnabled(false);
        simpleModeLabel.setText(_("tutti.label.frequencyConfiguration.no.configuration"));
    }

    protected void createSimpleModePanel() {
        $objectMap.put("simpleModePanel", simpleModePanel = new JPanel());
        
        simpleModePanel.setName("simpleModePanel");
        simpleModePanel.setLayout(new BorderLayout());
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setUseFloat(true);
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(_("tutti.label.frequencyConfiguration.step"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesFrequencyUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSpeciesFrequenciesTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(modePanel, BorderLayout.WEST);
        $JPanel0.add(modeConfigurationPanel, BorderLayout.CENTER);
        addChildrenToModePanel();
        addChildrenToSimpleModeButton();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToSimpleCountingModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToSimpleModePanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table0
        $Table0.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table1
        $Table1.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSimpleCountingModePanel();
        // inline complete setup of $Table2
        $Table2.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(lengthStepCaracteristicLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(lengthStepCaracteristicComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(stepLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(stepField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDataFieldPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $Table3
        $Table3.add(simpleCountingLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(simpleCountingField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToActionPanel();
        
        // apply 23 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 43 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        lengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        configurationPanel.setBorder(new TitledBorder(null, _("tutti.legend.frequencyConfiguration")));
        simpleModeLabel.setHorizontalAlignment(JLabel.CENTER);
        minStepLabel.setLabelFor(minStepField);
        minStepField.setBean(model);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setBean(model);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setModelType(Float.class);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        simpleCountingModeLabel.setHorizontalAlignment(JLabel.CENTER);
        lengthStepCaracteristicLabel.setLabelFor(lengthStepCaracteristicComboBox);
        lengthStepCaracteristicComboBox.setBean(model);
        stepLabel.setLabelFor(stepField);
        stepField.setBean(model);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        simpleCountingLabel.setLabelFor(simpleCountingField);
        simpleCountingField.setBean(model);
        simpleCountingField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        simpleCountingField.setNumberPattern(TuttiUI.INT_6_DIGITS_PATTERN);
        simpleCountingField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSpeciesFrequenciesTopPanel, "tuttihelp.editSpeciesFrequencies.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editSpeciesFrequenciesTopPanel", editSpeciesFrequenciesTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createModeConfigurationLayout();
        createDataFieldLayout();
        createConfigurationPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createModePanel();
        createSimpleModeButton();
        createAutoGenModeButton();
        createRafaleModeButton();
        createSimpleCountingModeButton();
        createModeConfigurationPanel();
        createSimpleModePanel();
        createSimpleModeLabel();
        createAutoGenModePanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createRafaleStepLabel();
        createRafaleStepField();
        createSimpleCountingModePanel();
        createSimpleCountingModeLabel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createLengthStepCaracteristicLabel();
        createLengthStepCaracteristicComboBox();
        createStepLabel();
        createStepField();
        createDataFieldPanel();
        createTableScrollPane();
        createTable();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createSimpleCountingLabel();
        createSimpleCountingField();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        createMode();
        // inline creation of editSpeciesFrequenciesTopPanel
        setName("editSpeciesFrequenciesTopPanel");
        setLayout(new BorderLayout());
        editSpeciesFrequenciesTopPanel.putClientProperty("help", "tuttihelp.editSpeciesFrequencies.help");
        
        // registers 23 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 23 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_FIELD_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dataFieldLayout.setSelected(model.isSimpleCountingMode() ? "noLengthCaracteristicPmfm" : "lengthCaracteristicPmfm");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleModeButton.setSelected(model.isSimpleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingModeButton.setSelected(model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setModel(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                minStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setModel(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                maxStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleStepField.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setModel(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                stepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingField.setModel(model.getSimpleCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}