package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SampleCategoryType.java 308 2013-02-03 13:06:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/SampleCategoryType.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.service.DecoratorService;

import java.util.EnumMap;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * All sample category types.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public enum SampleCategoryType implements DecoratorService.LabelAware {
    sortedUnsorted(
            n_("tutti.sampleCategoryType.sortedUnsorted"),
            SampleCategoryEnum.sortedUnsorted),
    size(
            n_("tutti.sampleCategoryType.size"),
            SampleCategoryEnum.size),
    sex(
            n_("tutti.sampleCategoryType.sex"),
            SampleCategoryEnum.sex),
    maturity(
            n_("tutti.sampleCategoryType.maturity"),
            SampleCategoryEnum.maturity),
    age(
            n_("tutti.sampleCategoryType.age"),
            SampleCategoryEnum.age);

    private final String i18nKey;

    private final SampleCategoryEnum type;

    private SampleCategoryType(String i18nKey, SampleCategoryEnum type) {
        this.i18nKey = i18nKey;
        this.type = type;
    }

    @Override
    public String getLabel() {
        return _(i18nKey);
    }

    public SampleCategoryEnum getType() {
        return type;
    }

    public static SampleCategoryType valueOf(SampleCategoryEnum type) {
        SampleCategoryType result = enumToType.get(type);
        return result;
    }

    @Override
    public String toString() {
        return getLabel();
    }

    public static final EnumMap<SampleCategoryEnum, SampleCategoryType> enumToType;

    static {
        enumToType = Maps.newEnumMap(SampleCategoryEnum.class);
        enumToType.put(SampleCategoryEnum.sortedUnsorted, sortedUnsorted);
        enumToType.put(SampleCategoryEnum.size, size);
        enumToType.put(SampleCategoryEnum.sex, sex);
        enumToType.put(SampleCategoryEnum.maturity, maturity);
        enumToType.put(SampleCategoryEnum.age, age);

    }
}
