package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractTuttiBatchTableUIHandler.java 581 2013-03-12 09:10:25Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/AbstractTuttiBatchTableUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.sort.TableSortController;

import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import java.awt.Component;
import java.awt.event.FocusEvent;

/**
 * Abstract ui handler forbatch ui.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public abstract class AbstractTuttiBatchTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiBatchUIModel<R, M>, UI extends TuttiUI<M, ?>> extends AbstractTuttiTableUIHandler<R, M, UI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(AbstractTuttiBatchTableUIHandler.class);

    public abstract void selectFishingOperation(FishingOperation bean);

    protected AbstractTuttiBatchTableUIHandler(TuttiUI<?, ?> parentUi,
                                               UI ui,
                                               String... properties) {
        super(parentUi.getHandler().getContext(), ui, properties);
    }

    public final void saveSelectedRowIfRequired(FocusEvent event) {

        Component oppositeComponent = event.getOppositeComponent();

        JXTable parentContainer = null;

        if (oppositeComponent != null) {

            // check out if still on table
            parentContainer = SwingUtil.getParentContainer(
                    oppositeComponent, JXTable.class);
        }

        if (parentContainer == null) {

            // out of the table can save
            if (getModel().getFishingOperation() != null) {

                saveSelectedRowIfNeeded();
            }
        }
    }

    /**
     * To clear the table selection.
     * <p/>
     * This method is invoked before changing the fishing operation.
     *
     * @since 0.3
     */
    public final void clearTableSelection() {

        JXTable table = getTable();

        if (table.isEditing()) {

            // make sure to stop editor
            table.editingCanceled(null);
        }

        // make sure selection is empty (will remove bean from monitor)
        table.clearSelection();
    }

    protected void initBatchTable(JXTable table,
                                  TableColumnModel columnModel,
                                  AbstractTuttiTableModel<R> tableModel) {

        installTableKeyListener(columnModel, table);

//        JTableFilter tableFilter = new JTableFilter(table);
//        TableRowFilterSupport.forFilter(tableFilter).searchable(true).useTableRenderers(true).actions(true).apply();
//
//        tableFilter.addChangeListener(new IFilterChangeListener() {
//            @Override
//            public void filterChanged(ITableFilter<?> filter) {
//                if (log.isInfoEnabled()) {
//                    log.info("Filter changed " + filter);
//                }
//                TableModel model = filter.getTable().getModel();
//                int columnCount = model.getColumnCount();
//                for (int i = 0; i < columnCount; i++) {
//                    if (filter.isFiltered(i)) {
//                        Collection<DistinctColumnItem> filterState = filter.getFilterState(i);
//                        if (log.isInfoEnabled()) {
//                            log.info("Column " + i + " is filtered: " + filterState);
//                        }
//                    }
//                }
//            }
//        });

        TableSortController<TableModel> sorter = new TableSortController<TableModel>(tableModel);
        sorter.setSortable(false);
        table.setRowSorter(sorter);

        initTable(table);
    }
}
