/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.species;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Sex;
import fr.ifremer.tutti.persistence.entities.referential.SortedUnsortedCategory;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.WeightCategory;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesFrequencyRowModel;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SpeciesBatchRowModel
extends AbstractTuttiBeanUIModel<SpeciesBatch, SpeciesBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY = "sortedUnsortedCategory";
    public static final String PROPERTY_WEIGHT_CATEGORY = "weightCategory";
    public static final String PROPERTY_SEX = "sex";
    public static final String PROPERTY_MATURITY = "maturity";
    public static final String PROPERTY_AGE = "age";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";
    public static final String PROPERTY_SAMPLING_RATIO = "samplingRatio";
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_FREQUENCY = "frequency";
    public static final String PROPERTY_COMPUTED_NUMBER = "computedNumber";
    public static final String PROPERTY_COMPUTED_WEIGHT = "computedWeight";
    public static final String PROPERTY_ATTACHMENTS = "attachments";
    protected Species species;
    protected boolean speciesToConfirm;
    protected SortedUnsortedCategory sortedUnsortedCategory;
    protected WeightCategory weightCategory;
    protected Sex sex;
    protected Float maturity;
    protected Float age;
    protected Float weight;
    protected Float computedWeight;
    protected Float computedNumber;
    protected Float sampleWeight;
    protected Float samplingRatio;
    protected String comment;
    protected List<Attachment> attachments;
    protected List<SpeciesFrequencyRowModel> frequency = Lists.newArrayList();
    protected static final Binder<SpeciesBatch, SpeciesBatchRowModel> fromBeanBinder = BinderFactory.newBinder(SpeciesBatch.class, SpeciesBatchRowModel.class);
    protected static final Binder<SpeciesBatchRowModel, SpeciesBatch> toBeanBinder = BinderFactory.newBinder(SpeciesBatchRowModel.class, SpeciesBatch.class);

    public SpeciesBatchRowModel() {
        super(SpeciesBatch.class, fromBeanBinder, toBeanBinder);
    }

    public SpeciesBatchRowModel(SpeciesBatch aBatch, List<SpeciesBatchFrequency> frequencies) {
        this();
        this.fromBean(aBatch);
        List<SpeciesFrequencyRowModel> frequencyRows = SpeciesFrequencyRowModel.fromBeans(frequencies);
        this.frequency.addAll(frequencyRows);
        Collections.sort(this.frequency);
        this.updateTotalFromFrequencies();
    }

    public void updateTotalFromFrequencies() {
        Float totalNumber = null;
        Float totalWeight = null;
        if (CollectionUtils.isNotEmpty(this.frequency)) {
            totalNumber = Float.valueOf(0.0f);
            totalWeight = Float.valueOf(0.0f);
            for (SpeciesFrequencyRowModel frequencyModel : this.frequency) {
                totalNumber = Float.valueOf(totalNumber.floatValue() + (float)frequencyModel.getNumber().intValue());
                Float w = frequencyModel.getWeight();
                if (w == null) {
                    totalWeight = null;
                    continue;
                }
                if (totalWeight == null) continue;
                totalWeight = Float.valueOf(totalWeight.floatValue() + w.floatValue());
            }
        }
        this.setComputedNumber(totalNumber);
        this.setComputedWeight(totalWeight);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        Species oldValue = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    public Boolean getSpeciesToConfirm() {
        return this.speciesToConfirm;
    }

    public void setSpeciesToConfirm(Boolean speciesToConfirm) {
        Boolean oldValue = this.getSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        this.firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    public SortedUnsortedCategory getSortedUnsortedCategory() {
        return this.sortedUnsortedCategory;
    }

    public void setSortedUnsortedCategory(SortedUnsortedCategory sortedUnsortedCategory) {
        SortedUnsortedCategory oldValue = this.getSortedUnsortedCategory();
        this.sortedUnsortedCategory = sortedUnsortedCategory;
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY, oldValue, sortedUnsortedCategory);
    }

    public WeightCategory getWeightCategory() {
        return this.weightCategory;
    }

    public void setWeightCategory(WeightCategory weightCategory) {
        WeightCategory oldValue = this.getWeightCategory();
        this.weightCategory = weightCategory;
        this.firePropertyChange(PROPERTY_WEIGHT_CATEGORY, oldValue, weightCategory);
    }

    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        Sex oldValue = this.getSex();
        this.sex = sex;
        this.firePropertyChange(PROPERTY_SEX, oldValue, sex);
    }

    public Float getMaturity() {
        return this.maturity;
    }

    public void setMaturity(Float maturity) {
        Float oldValue = this.getMaturity();
        this.maturity = maturity;
        this.firePropertyChange(PROPERTY_MATURITY, oldValue, maturity);
    }

    public Float getAge() {
        return this.age;
    }

    public void setAge(Float age) {
        Float oldValue = this.getAge();
        this.age = age;
        this.firePropertyChange(PROPERTY_AGE, oldValue, age);
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float weight) {
        Float oldValue = this.getWeight();
        this.weight = weight;
        this.firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public Float getSampleWeight() {
        return this.sampleWeight;
    }

    public void setSampleWeight(Float sampleWeight) {
        Float oldValue = this.getSampleWeight();
        this.sampleWeight = sampleWeight;
        this.firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    public Float getSamplingRatio() {
        return this.samplingRatio;
    }

    public void setSamplingRatio(Float samplingRatio) {
        Float oldValue = this.getSamplingRatio();
        this.samplingRatio = samplingRatio;
        this.firePropertyChange(PROPERTY_SAMPLING_RATIO, oldValue, samplingRatio);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        List<Attachment> oldValue = this.getAttachments();
        this.attachments = attachments;
        this.firePropertyChange(PROPERTY_ATTACHMENTS, oldValue, attachments);
    }

    public List<SpeciesFrequencyRowModel> getFrequency() {
        return this.frequency;
    }

    public void setFrequency(List<SpeciesFrequencyRowModel> frequency) {
        List<SpeciesFrequencyRowModel> oldValue = this.getFrequency();
        this.frequency = frequency;
        this.firePropertyChange(PROPERTY_FREQUENCY, oldValue, frequency);
    }

    public Float getComputedWeight() {
        return this.computedWeight;
    }

    public void setComputedWeight(Float computedWeight) {
        Float oldValue = this.getComputedWeight();
        this.computedWeight = computedWeight;
        this.firePropertyChange(PROPERTY_COMPUTED_WEIGHT, oldValue, computedWeight);
    }

    public Float getComputedNumber() {
        return this.computedNumber;
    }

    public void setComputedNumber(Float computedNumber) {
        Float oldValue = this.getComputedNumber();
        this.computedNumber = computedNumber;
        this.firePropertyChange(PROPERTY_COMPUTED_NUMBER, oldValue, computedNumber);
    }

    public int getRowCount() {
        return this.frequency == null ? 0 : this.frequency.size();
    }
}

