/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.accidental;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.accidental.AccidentalBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.accidental.AccidentalBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.accidental.AccidentalBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentCellComponent;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class AccidentalBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<AccidentalBatchRowModel, AccidentalBatchUIModel> {
    private static final Log log = LogFactory.getLog(AccidentalBatchUIHandler.class);
    private final AccidentalBatchUI ui;

    public AccidentalBatchUIHandler(FishingOperationsUI parentUi, AccidentalBatchUI ui) {
        super(parentUi, ArrayUtils.EMPTY_STRING_ARRAY, "species", "weight", "comment");
        this.ui = ui;
    }

    @Override
    protected AccidentalBatchUIModel getModel() {
        return this.ui.getModel();
    }

    protected AccidentalBatchTableModel getTableModel() {
        return (AccidentalBatchTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getTable();
    }

    @Override
    protected FishingOperation getFishingOperation() {
        return this.getModel().getFishingOperation();
    }

    @Override
    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        List allSpecies = this.persistenceService.getAllSpecies();
        Decorator<Species> decorator = this.getDecorator(Species.class, "byCode");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.SPECIES_BY_CODE, decorator, allSpecies);
        decorator = this.getDecorator(Species.class, "byGenus");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.SPECIES_BY_GENUS_CODE, decorator, allSpecies);
        this.addFloatColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(this.ui.getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), AccidentalBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellComponent.newEditor(this.ui.getAttachmentEditor()), AttachmentCellComponent.newRender(this.getDecorator(Attachment.class, null), I18n.n_((String)"tutti.tooltip.attachment.none", (Object[])new Object[0])), AccidentalBatchTableModel.ATTACHMENTS);
        return columnModel;
    }

    @Override
    protected void onRowModified(AccidentalBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        boolean wasValid = row.isValid();
        boolean valid = this.isRowValid(row);
        if (log.isInfoEnabled()) {
            log.info((Object)("Was valid / Is valid: " + wasValid + " / " + valid));
        }
        row.setValid(valid);
    }

    @Override
    protected void onRowValidStateChanged(AccidentalBatchRowModel row, Boolean oldValue, Boolean newValue) {
        int rowIndex = this.getTableModel().getRowIndex(row);
        if (rowIndex > -1) {
            this.getTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    protected void onRowModifyStateChanged(AccidentalBatchRowModel row, Boolean oldValue, Boolean newValue) {
    }

    @Override
    protected void onModelRowsChanged(List<AccidentalBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        for (AccidentalBatchRowModel row : rows) {
            boolean valid = this.isRowValid(row);
            row.setValid(valid);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired() {
        TuttiBeanMonitor rowMonitor = this.getRowMonitor();
        AccidentalBatchRowModel bean = (AccidentalBatchRowModel)((Object)rowMonitor.getBean());
        if (bean != null) {
            if (bean.isValid()) {
                if (rowMonitor.wasModified()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Row " + (Object)((Object)bean) + " was modified, will save it"));
                    }
                    this.saveRow(bean);
                    rowMonitor.clearModified();
                }
            } else {
                AccidentalBatch catchBean = (AccidentalBatch)bean.toBean();
                if (!TuttiEntities.isNew((IdAware)catchBean)) {
                    this.persistenceService.deleteAccidentalBatch(catchBean.getId());
                }
            }
        }
    }

    @Override
    protected boolean isRowValid(AccidentalBatchRowModel row) {
        boolean result = row.getSpecies() != null && row.getWeight() != null;
        return result;
    }

    @Override
    protected void saveRow(AccidentalBatchRowModel row) {
        AccidentalBatch catchBean = (AccidentalBatch)row.toBean();
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew((IdAware)catchBean)) {
            catchBean = this.persistenceService.createAccidentalBatch(catchBean);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.saveAccidentalBatch(catchBean);
        }
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        String fishingoperationText;
        ArrayList rows;
        JXTable table = this.getTable();
        if (table.isEditing()) {
            table.editingCanceled(null);
        }
        if (this.fishingOperationMonitor.wasModified()) {
            AccidentalBatchUIModel beanToSave = (AccidentalBatchUIModel)((Object)this.fishingOperationMonitor.getBean());
            FishingOperation fishingOperation = (FishingOperation)beanToSave.toBean();
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + fishingOperation.getId() + " was modified, will save it."));
            }
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
        table.clearSelection();
        boolean empty = bean == null;
        AccidentalBatchUIModel model = this.getModel();
        if (empty) {
            rows = null;
            bean = new FishingOperation();
            model.setFishingOperation(null);
            fishingoperationText = "";
        } else {
            Decorator<FishingOperation> decorator = this.getDecorator(FishingOperation.class, null);
            fishingoperationText = I18n._((String)"tutti.label.traitReminder", (Object[])new Object[]{decorator.toString((Object)bean)});
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId() + " - " + fishingoperationText));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((IdAware)bean)) {
                List catches = this.persistenceService.getAllAccidentalBatch(bean.getId());
                for (AccidentalBatch aBatch : catches) {
                    AccidentalBatchRowModel entry = new AccidentalBatchRowModel(aBatch);
                    rows.add(entry);
                }
            }
            model.setFishingOperation(bean);
        }
        model.fromBean(bean);
        model.setRows(rows);
        this.fishingOperationMonitor.clearModified();
        this.ui.getFishingOperationReminderLabel().setText(fishingoperationText);
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        AccidentalBatchUIModel model = new AccidentalBatchUIModel();
        this.ui.setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        TableColumnModel columnModel = this.createTableColumnModel();
        AccidentalBatchTableModel tableModel = new AccidentalBatchTableModel(columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel(columnModel);
        this.initBatchTable(table, columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }
}

