package fr.ifremer.tutti.ui.swing.util.editor;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class AttachmentEditorUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_PROPERTY = "property";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UQW8TRxR+NrETJ0SkiUhBBSmUFvXScVupUtVUQAK1SGQKIlAhfOl4d4IHjXe2M2+bRVErfkJ/QnvvpRI3TohDzxy4IP5CVfXQa9U3u2vvrr2RQy3Z8s5873vfe/ve99uf0LAGLjziccxMFKAcCra7df/+rf4j4eF1YT0jQ9QG0k+tDvUeLPnjc4twsdd14e0svH1ND0MdiKAQvdmFRYuPlbADIRDhfDnCs7a9N77ejMPIjFjHoqpYf/n7r/rP/pNf6wBxSOpWqJSNWVF5JXNdqEsfYZUy/cDbigcPSYaRwUPSu+zOrilu7Td8KL6Hn2C+C82QGyJDeP/4JSccSXwcIrSGXAa3eSAUwhf7hsl9I4bCMIwQJYsksweUn0UoFRO+JCK2hci9wZDYv04O7u2EYULYRFgIjQ6FwccIK04wc0WwtIgCyjHxvhII7+Soba2V4EEOm+vTI8JnR8va6ls03MO77nib0Pd2bmpfqJxjfsADX5EiuPJ/q7uRMuScjaHLgfD5FCOVbqVFEXiCEYNEKSzzOfICbc6zxMeHNLbvlgYlFfbtto4duDWOae1LJbq87/Kvut7FGXQ3OSyD5xwYYb2Euyti7Eih/Ali7vvbVISmjq+VAtLTMnrZMbtBHGfdKAMWRgD3fLF8t+LuaERd4UfFL3+wu+cZrZSbzU+S7hQk5VflqKUCM8Lpqbq3jOAO+nEe4SltRV7ipYzQwHul90GWwHJLyHe21oOGiegY4Uxv2kXu0FXqH2cm/MMRJrf/rq+9evbmaWdkGk3KfboSWvA8WuZs06RLfSp1DDfH7Zs83OxBywpFhpkY4rkKYXvZNYmjfOkWJmtwg9sBUTTmXz9/sf7dyxNQ78Ci0tzvcIffgRYODHVBKz8Or1xNFJ08WHBuR986vXnlXmlH08o1D937+JEGEan5CBfSLUkAjE8sGnPYmDp1rqJTY7n91h//rO39fnXUrRqpP3skPO9Y4wE0ZaBkIBKTzfyz0lSXQisiX+c+WeWcUFzFMNvpL5PfyzO6sng42o28Mx/O7IzDx5Hjv56U7f51YHIT307J8mFhX3IxH80Uk4VU6Zla7lmSatQRGi2pgx3Pmc8JMqIq4tygjlFkVslqWklKz5JVn8jWSA6r8hWd4Rg1zBl9QLu2+lU6ZRvUNyP7EYrLU+Q19/spcf4HjSeqa+4IAAA=";
    private static final Log log = LogFactory.getLog(AttachmentEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected VBox attachments;
    protected AbstractTuttiBeanUIModel bean;
    protected JButton closeButton;
    protected Boolean editable;
    protected JTextField file;
    protected JTextArea fileComment;
    protected JLabel fileCommentLabel;
    protected JLabel fileLabel;
    protected JTextField fileName;
    protected JLabel fileNameLabel;
    protected AttachmentEditorUIHandler handler;
    protected AttachmentEditorUI mainPanel = this;
    protected Attachment model;
    protected String property;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI() {
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAttachment();
    }

    public void doActionPerformed__on__closeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close();
    }

    public void doMouseClicked__on__file(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.chooseFile();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public VBox getAttachments() {
        return attachments;
    }

    public AbstractTuttiBeanUIModel getBean() {
        return bean;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public Boolean getEditable() {
        return editable;
    }

    public JTextField getFile() {
        return file;
    }

    public JTextArea getFileComment() {
        return fileComment;
    }

    public JLabel getFileCommentLabel() {
        return fileCommentLabel;
    }

    public JLabel getFileLabel() {
        return fileLabel;
    }

    public JTextField getFileName() {
        return fileName;
    }

    public JLabel getFileNameLabel() {
        return fileNameLabel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public Attachment getModel() {
        return model;
    }

    public String getProperty() {
        return property;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(AbstractTuttiBeanUIModel bean) {
        AbstractTuttiBeanUIModel oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setModel(Attachment model) {
        Attachment oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachments, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(fileLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(file, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addButton, new GridBagConstraints(2, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(fileNameLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(fileName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(fileCommentLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(closeButton, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createAttachments() {
        $objectMap.put("attachments", attachments = new VBox());
        
        attachments.setName("attachments");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.action.close"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createFile() {
        $objectMap.put("file", file = new JTextField());
        
        file.setName("file");
        file.setColumns(15);
        file.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__file"));
    }

    protected void createFileComment() {
        $objectMap.put("fileComment", fileComment = new JTextArea());
        
        fileComment.setName("fileComment");
        fileComment.setColumns(15);
        fileComment.setLineWrap(true);
        fileComment.setWrapStyleWord(true);
        fileComment.setRows(3);
    }

    protected void createFileCommentLabel() {
        $objectMap.put("fileCommentLabel", fileCommentLabel = new JLabel());
        
        fileCommentLabel.setName("fileCommentLabel");
        fileCommentLabel.setText(_("tutti.label.attachmentEditor.fileComment"));
    }

    protected void createFileLabel() {
        $objectMap.put("fileLabel", fileLabel = new JLabel());
        
        fileLabel.setName("fileLabel");
        fileLabel.setText(_("tutti.label.attachmentEditor.file"));
    }

    protected void createFileName() {
        $objectMap.put("fileName", fileName = new JTextField());
        
        fileName.setName("fileName");
        fileName.setColumns(15);
    }

    protected void createFileNameLabel() {
        $objectMap.put("fileNameLabel", fileNameLabel = new JLabel());
        
        fileNameLabel.setName("fileNameLabel");
        fileNameLabel.setText(_("tutti.label.attachmentEditor.fileName"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AttachmentEditorUIHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fileComment);
        
        // apply 5 property setters
        fileLabel.setLabelFor(file);
        addButton.setIcon(SwingUtil.createActionIcon("add"));
        fileNameLabel.setLabelFor(fileName);
        fileCommentLabel.setLabelFor(fileComment);
        closeButton.setIcon(SwingUtil.createActionIcon("close"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainPanel", mainPanel);
        createProperty();
        createEditable();
        createBean();
        createHandler();
        createModel();
        createAttachments();
        createFileLabel();
        createFile();
        createAddButton();
        createFileNameLabel();
        createFileName();
        createFileCommentLabel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFileComment();
        createCloseButton();
        // inline creation of mainPanel
        setName("mainPanel");
        
        $completeSetup();
    }

}