/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.ImportResults;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import fr.ifremer.suiviobsmer.entity.SampleMonth;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.WaoUser;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/sampling.css"})
public class SamplingPlan
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @Inject
    private ServiceSampling serviceSampling;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private WaoUser user;
    @Property
    private UploadedFile samplingPlanCsvFile;
    @Persist
    private PeriodDates period;
    @Property
    private Date periodBegin;
    @Property
    private Date periodEnd;
    private List<SampleRow> data;
    private List<Date> months;
    @Property
    private Date month;
    @Property
    private SampleRow row;
    @Property
    private String currentFacadeName;
    @Property
    private String currentSectorName;
    @Property
    private int rowIndex;

    public boolean isOnlyForAdmin() {
        return false;
    }

    void setupRender() {
        this.periodBegin = this.getPeriod().getFromDate();
        this.periodEnd = this.getPeriod().getThruDate();
    }

    @Log
    void onSuccessFromImportSamplingPlan() throws SuiviObsmerException {
        try {
            ImportResults result = this.serviceSampling.importSamplingPlanCsv(this.samplingPlanCsvFile.getStream());
            this.layout.getFeedBack().addInfo(result.getNbRowsImported() + " lignes du plan import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
            for (String error : result.getErrors()) {
                this.layout.getFeedBack().addInfo(error);
            }
        }
        catch (SuiviObsmerBusinessException eee) {
            this.layout.getFeedBack().addError(eee.getMessage());
        }
    }

    public PeriodDates getPeriod() {
        if (this.period == null) {
            this.period = PeriodDates.createMonthsPeriodFromToday((int)11);
        }
        return this.period;
    }

    void onSuccessFromPeriodForm() {
        if (this.periodBegin != null && this.periodEnd != null) {
            this.period.setFromDate(this.periodBegin);
            this.period.setThruDate(this.periodEnd);
        }
    }

    public List<SampleRow> getData() throws SuiviObsmerException {
        if (this.data == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRowsOrderedByFishingZone]");
            }
            Company company = null;
            if (!this.user.getAdmin()) {
                company = this.user.getCompany();
            }
            this.data = this.serviceSampling.getSampleRowsOrderedByFishingZone(this.getPeriod(), company);
        }
        return this.data;
    }

    public List<Date> getMonths() {
        if (this.months == null) {
            this.months = this.getPeriod().getMonths();
        }
        return this.months;
    }

    public boolean isFacadeChanged() {
        if (!this.row.getFacade().equals(this.currentFacadeName)) {
            this.currentFacadeName = this.row.getFacade();
            return true;
        }
        return false;
    }

    public boolean isSectorChanged() {
        if (!this.row.getSectors().equals(this.currentSectorName)) {
            this.currentSectorName = this.row.getSectors();
            return true;
        }
        return false;
    }

    public String getCompanyName() {
        return this.row.getCompany() != null ? this.row.getCompany().getName() : "";
    }

    public boolean isCurrentMonth() {
        String currentStr = this.getDateFormat().format(new Date());
        String monthStr = this.getDateFormat().format(this.month);
        return currentStr.equals(monthStr);
    }

    public Integer getNbTidesExpected() {
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            return sampleMonth.getExpectedTidesValue();
        }
        return null;
    }

    public String getFishingZones() {
        String result = "";
        for (FishingZone zone : this.row.getFishingZone()) {
            result = result + zone.getDistrictCode() + ", ";
        }
        return result.substring(0, result.length() - 2);
    }

    public Integer getNbTidesReal() {
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            return sampleMonth.getRealTidesValue();
        }
        return null;
    }

    public boolean hasNbTidesReal() {
        Date current = new Date();
        boolean validMonth = this.month.before(current) || this.isCurrentMonth();
        return validMonth && this.getNbTidesReal() != null;
    }

    public int getTotalTidesExpected() {
        int total = 0;
        for (Date currentMonth : this.getMonths()) {
            SampleMonth sampleMonth = this.row.getSampleMonth(currentMonth);
            if (sampleMonth == null) continue;
            total += sampleMonth.getExpectedTidesValue();
        }
        return total;
    }

    public int getTotalTidesReal() {
        int total = 0;
        for (Date currentMonth : this.getMonths()) {
            SampleMonth sampleMonth = this.row.getSampleMonth(currentMonth);
            if (sampleMonth == null) continue;
            total += sampleMonth.getRealTidesValue();
        }
        return total;
    }

    public String getTotalPercentage() {
        double result = 0.0;
        if (this.getTotalTidesExpected() > 0) {
            result = (double)this.getTotalTidesReal() / (double)this.getTotalTidesExpected();
        }
        return NumberFormat.getPercentInstance().format(result);
    }

    public NumberFormat getNumberFormat() {
        return NumberFormat.getNumberInstance();
    }

    public int getNbColumnsForProfession() {
        int fixed = 5;
        if (this.user.getAdmin()) {
            fixed += 8;
        }
        return fixed;
    }

    public int getNbColumnsForMonths() {
        return this.getMonths().size() + 1;
    }

    public int getNbColumnsForOther() {
        return 3;
    }

    public int getNbColumnsTotal() {
        return this.getNbColumnsForProfession() + this.getNbColumnsForMonths() + this.getNbColumnsForOther();
    }

    public String getMainClass() {
        return this.user.getAdmin() ? "admin" : "user";
    }

    public String getParityClass() {
        return this.rowIndex % 2 == 0 ? "even" : "odd";
    }

    public String getActionsClass() {
        return this.user.getAdmin() ? "width100" : "width30";
    }

    public String getRealTidesClass() {
        String result = "real-warning";
        if (this.getNbTidesReal() < this.getNbTidesExpected()) {
            result = result + "-inf";
        } else if (this.getNbTidesReal() > this.getNbTidesExpected()) {
            result = result + "-sup";
        }
        return result;
    }

    public String getMonthCurrentClass() {
        return this.isCurrentMonth() ? "current" : "";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    void onActionFromFilterPeriodDates(int rowIndex) throws SuiviObsmerException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        this.period.setFromDate(this.row.getPeriodBegin());
        this.period.setThruDate(this.row.getPeriodEnd());
    }

    void onActionFromDeleteSampleRow(int rowIndex) throws SuiviObsmerException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        this.serviceSampling.deleteSampleRow(this.row);
    }

    public boolean canAccessBoats() {
        return !this.row.isFinished(-1);
    }
}

