/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/userProfile.css"})
public class UserProfile
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @Inject
    private ServiceUser serviceUser;
    @InjectComponent
    private Layout layout;
    @SessionState
    private User user;
    private User userEditable;
    @InjectComponent
    private BeanEditForm userForm;
    @Property
    private String password;
    @Property
    private String password2;

    public boolean isOnlyForAdmin() {
        return false;
    }

    public User getUserEditable() {
        if (this.userEditable == null) {
            this.userEditable = this.user;
        }
        return this.userEditable;
    }

    void onSuccessFromUserForm() throws SuiviObsmerException {
        if (this.password != null && !this.password.equals(this.password2)) {
            this.userForm.recordError("Les deux password ne sont pas identiques, v\u00e9rifiez la saisie !");
        } else {
            try {
                if (!StringUtils.isEmpty((String)this.password)) {
                    this.userEditable.setPassword(this.password);
                    this.userEditable.setPasswordChanged(true);
                }
                this.serviceUser.createUpdateUser(this.userEditable, false);
                this.layout.getFeedBack().addInfo("Modifications enregistr\u00e9es avec succ\u00e8s !");
            }
            catch (SuiviObsmerBusinessException eee) {
                this.userForm.recordError(eee.getMessage());
            }
        }
    }
}

