/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.base;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.SamplingFilter;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceReferential;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.slf4j.Logger;

public abstract class AbstractFilteredPage {
    @Inject
    private Logger log;
    @SessionState
    private User user;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private ServiceUser serviceUser;
    @Persist
    private GenericSelectModel<SampleRow> sampleRowSelectModel;
    @Property
    private String sampleRowId;
    @Persist
    private SelectModel facadeSelectModel;
    @Persist
    private SelectModel sectorSelectModel;
    @Persist
    private GenericSelectModel<Company> companySelectModel;
    @Property
    private String companyId;
    @Persist
    private GenericSelectModel<User> observerSelectModel;
    @Property
    private String observerId;

    protected void initFilter() throws SuiviObsmerException {
        this.facadeSelectModel = null;
        this.getFacadeSelectModel();
        this.sectorSelectModel = null;
        this.getSectorSelectModel();
        this.sampleRowSelectModel = null;
        this.getSampleRowSelectModel();
        if (this.getFilter().getSampleRow() != null) {
            this.sampleRowId = this.getFilter().getSampleRow().getTopiaId();
        }
        if (this.user.getAdmin()) {
            this.companySelectModel = null;
            this.getCompanySelectModel();
            if (this.getFilter().getCompany() != null) {
                this.companyId = this.getFilter().getCompany().getTopiaId();
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Company filtered : " + this.user.getCompany());
            }
            this.getFilter().setCompany(this.user.getCompany());
        }
        this.observerSelectModel = null;
        this.getObserverSelectModel();
        if (this.getFilter().getObserver() != null) {
            this.observerId = this.getFilter().getObserver().getTopiaId();
        }
    }

    public SelectModel getFacadeSelectModel() throws SuiviObsmerException {
        if (this.facadeSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getFacades]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String facadeName : this.serviceReferential.getFacades()) {
                options.add(new OptionModelImpl(facadeName, (Object)facadeName));
            }
            this.facadeSelectModel = new SelectModelImpl(null, options);
        }
        return this.facadeSelectModel;
    }

    public SelectModel getSectorSelectModel() throws SuiviObsmerException {
        if (this.sectorSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSectors]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String sectorName : this.serviceReferential.getSectors(this.getFilter().getFacadeName())) {
                options.add(new OptionModelImpl(sectorName, (Object)sectorName));
            }
            this.sectorSelectModel = new SelectModelImpl(null, options);
        }
        return this.sectorSelectModel;
    }

    public GenericSelectModel<SampleRow> getSampleRowSelectModel() throws SuiviObsmerException {
        if (this.sampleRowSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRowsForUser]");
            }
            List sampleRows = this.serviceSampling.getSampleRowsByFilter((SamplingFilter)this.getFilter());
            this.sampleRowSelectModel = new GenericSelectModel(sampleRows, SampleRow.class, "code", "topiaId", this.propertyAccess);
        }
        return this.sampleRowSelectModel;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws SuiviObsmerException {
        if (this.companySelectModel == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("BUSINESS REQUEST [getCompanies]");
            }
            List companies = this.serviceUser.getCompanies(this.getAvailableDataForFiltersOnly());
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public GenericSelectModel<User> getObserverSelectModel() throws SuiviObsmerException {
        if (this.observerSelectModel == null) {
            List observers = new ArrayList();
            if (this.getFilter().getCompany() != null) {
                observers = this.getFilter().getCompany().getUser();
            } else if (this.user.getAdmin()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("BUSINESS REQUEST [getObservers]");
                }
                observers = this.serviceUser.getObservers(this.getAvailableDataForFiltersOnly());
            }
            this.observerSelectModel = new GenericSelectModel(observers, User.class, "fullName", "topiaId", this.propertyAccess);
        }
        return this.observerSelectModel;
    }

    protected abstract BoatFilter getFilter() throws SuiviObsmerException;

    protected abstract void resetFilter();

    protected abstract boolean getAvailableDataForFiltersOnly();

    public String[] onProvideCompletionsFromBoatName(String input) throws SuiviObsmerException {
        if (this.log.isInfoEnabled()) {
            this.log.info("BUSINESS REQUEST [getBoatNamesStartWith]");
        }
        List results = this.serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[0]);
    }

    @Log
    public void onSuccess() throws SuiviObsmerException {
        SampleRow row = (SampleRow)this.getSampleRowSelectModel().findObject(this.sampleRowId);
        this.getFilter().setSampleRow(row);
        if (this.user.getAdmin()) {
            Company company = (Company)this.getCompanySelectModel().findObject(this.companyId);
            this.getFilter().setCompany(company);
        }
        User observer = (User)this.getObserverSelectModel().findObject(this.observerId);
        this.getFilter().setObserver(observer);
    }
}

