/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.setofvessels;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.setofvessels.EffortDescriptionUI;
import fr.ifremer.isisfish.util.ErrorHelper;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EffortDescriptionHandler
extends InputContentHandler<EffortDescriptionUI> {
    private static final Log log = LogFactory.getLog(EffortDescriptionHandler.class);

    protected EffortDescriptionHandler(EffortDescriptionUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((EffortDescriptionUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            if (evt.getNewValue() == null) {
                ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionMetierModel.setElementList(null);
                ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionEffortDescriptionModel.setElementList(null);
            }
            if (evt.getNewValue() != null) {
                this.setEffortDescriptionEffortDescriptionModel();
            }
        });
    }

    protected void onFieldEffortDescriptionMetierListValueChanged() {
        if (((EffortDescriptionUI)this.inputContentUI).isActive().booleanValue()) {
            ((EffortDescriptionUI)this.inputContentUI).buttonEffortDescriptionAdd.setEnabled(((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionMetierList.getSelectedIndex() != -1);
        }
    }

    protected void onFieldEffortDescriptionEffortDescriptionListValueChanged() {
        if (((EffortDescriptionUI)this.inputContentUI).isActive().booleanValue()) {
            ((EffortDescriptionUI)this.inputContentUI).removeEffortDescriptionButton.setEnabled(((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionEffortDescriptionList.getSelectedIndex() != -1);
        }
    }

    protected void setEffortDescriptionEffortDescriptionModel() {
        if (((EffortDescriptionUI)this.inputContentUI).getBean() != null && ((EffortDescriptionUI)this.inputContentUI).getBean().getPossibleMetiers() != null) {
            List<Metier> availableMetiers = ((EffortDescriptionUI)this.inputContentUI).getFisheryRegion().getMetier();
            ArrayList<EffortDescription> effortDescriptions = new ArrayList<EffortDescription>(((EffortDescriptionUI)this.inputContentUI).getBean().getPossibleMetiers());
            effortDescriptions.stream().map(EffortDescription::getPossibleMetiers).forEach(availableMetiers::remove);
            ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionEffortDescriptionModel.setElementList(effortDescriptions);
            ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionMetierModel.setElementList(availableMetiers);
        }
    }

    protected void addEffortDescriptions(MouseEvent event) {
        if (event != null && event.getClickCount() != 2) {
            return;
        }
        List<Metier> selectedValues = ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionMetierList.getSelectedValuesList();
        for (Metier selectedMetier : selectedValues) {
            this.addEffortDescription(((EffortDescriptionUI)this.inputContentUI).getBean(), selectedMetier);
        }
        this.setEffortDescriptionEffortDescriptionModel();
    }

    protected void removeEffortDescriptions(MouseEvent event) {
        if (event != null && event.getClickCount() != 2) {
            return;
        }
        List<EffortDescription> selectedValues = ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionEffortDescriptionList.getSelectedValuesList();
        for (EffortDescription selectedEffortDescription : selectedValues) {
            this.removeEffortDescription(((EffortDescriptionUI)this.inputContentUI).getBean(), selectedEffortDescription);
        }
        this.setEffortDescriptionEffortDescriptionModel();
    }

    protected void addEffortDescription(SetOfVessels setOfVessels, Metier metier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addEffortDescription called: " + String.valueOf(setOfVessels) + " metier: " + String.valueOf(metier)));
        }
        try {
            EffortDescriptionDAO effortDescriptionPS = IsisFishDAOHelper.getEffortDescriptionDAO(metier.getTopiaContext());
            EffortDescription effortDescription = (EffortDescription)effortDescriptionPS.create(new Object[0]);
            effortDescription.setSetOfVessels(setOfVessels);
            effortDescription.setPossibleMetiers(metier);
            effortDescription.update();
            setOfVessels.addPossibleMetiers(effortDescription);
            setOfVessels.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create EffortDescription", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
    }

    protected void removeEffortDescription(SetOfVessels sov, EffortDescription effort) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"removeEffortDescription called");
        }
        try {
            sov.removePossibleMetiers(effort);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't remove entity: " + String.valueOf(effort)), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
    }
}

