/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.cron;

import fr.ifremer.isisfish.cron.RemoveOldFileTask;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CronService
extends Thread {
    private static Log log = LogFactory.getLog(CronService.class);
    protected Collection<Runnable> services = new LinkedList<Runnable>();

    public CronService() {
        this.registerDefaultServices();
    }

    private void registerDefaultServices() {
        this.addService(new RemoveOldFileTask());
    }

    protected void addService(Runnable task) {
        this.services.add(task);
    }

    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting " + this.services.size() + " registered services"));
        }
        for (Runnable task : this.services) {
            Thread taskThread = new Thread(task);
            try {
                taskThread.start();
                taskThread.join();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Task " + task.getClass().getSimpleName() + " failed to run"), (Throwable)ex);
            }
        }
        this.services.clear();
    }
}

