/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.spatial;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellImpl;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.spatial.AskNewSpatialUI;
import fr.ifremer.isisfish.ui.input.spatial.ChangeSpatialPreviewUI;
import fr.ifremer.isisfish.util.CellPointcomparator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jaxx.runtime.JAXXContext;
import org.nuiton.topia.persistence.TopiaId;

public class AskNewSpatialHandler {
    protected AskNewSpatialUI ui;

    public AskNewSpatialHandler(AskNewSpatialUI ui) {
        this.ui = ui;
    }

    public void performSpatialChange() {
        FisheryRegion currentFisheryRegion = this.ui.getContextValue(FisheryRegion.class);
        FisheryRegion newFisheryRegion = this.ui.getBean();
        List<Cell> newCells = this.createNewCells(newFisheryRegion, currentFisheryRegion);
        Map<Zone, List<Cell>> zoneMap = this.createNewZones(newCells, newFisheryRegion, currentFisheryRegion);
        Map<Port, Cell> portMap = this.createNewPorts(newCells, newFisheryRegion, currentFisheryRegion);
        ChangeSpatialPreviewUI changeSpatialPreviewUI = new ChangeSpatialPreviewUI((JAXXContext)this.ui);
        changeSpatialPreviewUI.getHandler().setOldFisheryRegion(currentFisheryRegion);
        changeSpatialPreviewUI.getHandler().setNewFisheryRegion(newFisheryRegion);
        changeSpatialPreviewUI.getHandler().setCells(newCells);
        changeSpatialPreviewUI.getHandler().setZoneMap(zoneMap);
        changeSpatialPreviewUI.getHandler().setPortMap(portMap);
        changeSpatialPreviewUI.getHandler().completeSetup();
        changeSpatialPreviewUI.pack();
        changeSpatialPreviewUI.setLocationRelativeTo(this.ui);
        changeSpatialPreviewUI.setVisible(true);
        this.ui.dispose();
    }

    protected List<Cell> createNewCells(FisheryRegion newFisheryRegion, FisheryRegion currentFisheryRegion) {
        List<Cell> currentCells = currentFisheryRegion.getCell();
        CellPointcomparator cellPointcomparator = new CellPointcomparator();
        currentCells.sort(cellPointcomparator);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        Rectangle2D.Float intersect = new Rectangle2D.Float();
        for (float lati = newFisheryRegion.getMinLatitude(); lati < newFisheryRegion.getMaxLatitude(); lati += newFisheryRegion.getCellLengthLatitude()) {
            lati = Math.round(lati * 1000.0f);
            lati /= 1000.0f;
            for (float longi = newFisheryRegion.getMinLongitude(); longi < newFisheryRegion.getMaxLongitude(); longi += newFisheryRegion.getCellLengthLongitude()) {
                longi = (float)Math.round(longi * 1000.0f) / 1000.0f;
                CellImpl cell = new CellImpl();
                cell.setTopiaId(TopiaId.create(Cell.class));
                cell.setName("La" + lati + "Lo" + longi);
                cell.setLatitude(lati);
                cell.setLongitude(longi);
                cell.setLand(false);
                cells.add(cell);
                Rectangle2D.Float cellRect = new Rectangle2D.Float(cell.getLatitude(), cell.getLongitude(), newFisheryRegion.getCellLengthLatitude(), newFisheryRegion.getCellLengthLongitude());
                for (Cell currentCell : currentCells) {
                    Rectangle2D.Float curCellRect = new Rectangle2D.Float(currentCell.getLatitude(), currentCell.getLongitude(), currentFisheryRegion.getCellLengthLatitude(), currentFisheryRegion.getCellLengthLongitude());
                    double overlap = this.intersectPercentage(cellRect, curCellRect, intersect);
                    if (!(overlap >= 0.5)) continue;
                    cell.setLand(currentCell.isLand());
                }
            }
        }
        return cells;
    }

    protected Map<Zone, List<Cell>> createNewZones(List<Cell> newCells, FisheryRegion newFisheryRegion, FisheryRegion currentFisheryRegion) {
        HashMap<Zone, List<Cell>> zonesAndNewCells = new HashMap<Zone, List<Cell>>();
        List<Zone> zones = currentFisheryRegion.getZone();
        Rectangle2D.Float intersect = new Rectangle2D.Float();
        for (Zone zone : zones) {
            HashSet<Cell> zoneNewCells = new HashSet<Cell>();
            for (Cell newCell : newCells) {
                Rectangle2D.Float newCellRect = new Rectangle2D.Float(newCell.getLatitude(), newCell.getLongitude(), newFisheryRegion.getCellLengthLatitude(), newFisheryRegion.getCellLengthLongitude());
                for (Cell currentCell : zone.getCell()) {
                    Rectangle2D.Float currentCellRect = new Rectangle2D.Float(currentCell.getLatitude(), currentCell.getLongitude(), currentFisheryRegion.getCellLengthLatitude(), currentFisheryRegion.getCellLengthLongitude());
                    double overlap = this.intersectPercentage(newCellRect, currentCellRect, intersect);
                    if (!(overlap >= 0.5)) continue;
                    zoneNewCells.add(newCell);
                }
            }
            zonesAndNewCells.put(zone, new ArrayList(zoneNewCells));
        }
        return zonesAndNewCells;
    }

    protected Map<Port, Cell> createNewPorts(List<Cell> newCells, FisheryRegion newFisheryRegion, FisheryRegion currentFisheryRegion) {
        HashMap<Port, Cell> portsAndNewCells = new HashMap<Port, Cell>();
        List<Port> ports = currentFisheryRegion.getPort();
        Rectangle2D.Float intersect = new Rectangle2D.Float();
        for (Port port : ports) {
            Cell currentCell = port.getCell();
            if (currentCell == null) continue;
            Cell portNewCell = null;
            double bestMatch = Double.MIN_VALUE;
            Rectangle2D.Float currentCellRect = new Rectangle2D.Float(currentCell.getLatitude(), currentCell.getLongitude(), currentFisheryRegion.getCellLengthLatitude(), currentFisheryRegion.getCellLengthLongitude());
            for (Cell newCell : newCells) {
                Rectangle2D.Float newCellRect = new Rectangle2D.Float(newCell.getLatitude(), newCell.getLongitude(), newFisheryRegion.getCellLengthLatitude(), newFisheryRegion.getCellLengthLongitude());
                double overlap = this.intersectPercentage(newCellRect, currentCellRect, intersect);
                if (!(overlap >= bestMatch)) continue;
                portNewCell = newCell;
                bestMatch = overlap;
            }
            portsAndNewCells.put(port, portNewCell);
        }
        return portsAndNewCells;
    }

    protected double intersectPercentage(Rectangle2D.Float r1, Rectangle2D.Float r2, Rectangle2D.Float intersect) {
        Rectangle2D.intersect(r1, r2, intersect);
        double result = 0.0;
        double fr1 = r1.getWidth() * r1.getHeight();
        double fr2 = r2.getWidth() * r2.getHeight();
        double fr = Math.min(fr1, fr2);
        if (fr > 0.0 && intersect.getWidth() > 0.0 && intersect.getHeight() > 0.0) {
            double f = intersect.getWidth() * intersect.getHeight();
            result = f / fr;
        }
        return result;
    }
}

