/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.config.IsisConfig;
import fr.ifremer.isisfish.ui.AboutDialog;
import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.WelcomeSaveVerifier;
import fr.ifremer.isisfish.ui.WelcomeTabUI;
import fr.ifremer.isisfish.ui.WelcomeUI;
import fr.ifremer.isisfish.ui.config.ConfigUI;
import fr.ifremer.isisfish.ui.config.RConfigUI;
import fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI;
import fr.ifremer.isisfish.ui.input.InputContext;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.queue.QueueUI;
import fr.ifremer.isisfish.ui.result.ResultUI;
import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityContext;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.simulator.SimulUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorContext;
import fr.ifremer.isisfish.util.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class WelcomeHandler
extends CommonHandler {
    private static Log log = LogFactory.getLog(WelcomeHandler.class);
    protected WelcomeUI welcomeUI;
    protected Map<JFrame, WelcomePanelUI> allFrameOpened;
    protected static final Map<String, String> URLSALIAS = new HashMap<String, String>();

    public WelcomeHandler(WelcomeUI welcomeUI) {
        this.welcomeUI = welcomeUI;
    }

    public void afterInit() {
        this.allFrameOpened = new HashMap<JFrame, WelcomePanelUI>();
        WelcomePanelUI welcomePanelUI = this.welcomeUI.getWelcomePanelUI();
        welcomePanelUI.setContent(new WelcomeTabUI((JAXXContext)welcomePanelUI));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(0);
        toolTipManager.setDismissDelay(60000);
    }

    protected void openFrame(WelcomeUI welcomeUI, Component c, String title) {
        WelcomePanelUI welcome = new WelcomePanelUI((JAXXContext)welcomeUI);
        welcome.setContent(c);
        JFrame frame = new JFrame(title);
        frame.setLayout(new BorderLayout());
        frame.add((Component)welcome, "Center");
        frame.setSize(new Dimension(800, 600));
        frame.setDefaultCloseOperation(0);
        this.allFrameOpened.put(frame, welcome);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                WelcomeHandler.this.allFrameOpened.get(f).close(f);
            }
        });
        UIUtil.setIconImage(frame);
        frame.setLocationRelativeTo(welcomeUI);
        frame.setVisible(true);
    }

    public void newSimulationFrame(WelcomeUI welcomeUI) {
        SimulatorContext simulatorContext = new SimulatorContext((JAXXContext)welcomeUI);
        SimulUI simulUI = new SimulUI((JAXXContext)simulatorContext);
        this.openFrame(welcomeUI, simulUI, I18n.t((String)"isisfish.simulation.title", (Object[])new Object[0]));
    }

    public void newResultFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, new ResultUI(), I18n.t((String)"isisfish.result.title", (Object[])new Object[0]));
    }

    public void newInputFrame(WelcomeUI welcomeUI) {
        InputContext inputContext = new InputContext((JAXXContext)welcomeUI);
        InputUI inputUI = new InputUI((JAXXContext)inputContext);
        this.openFrame(welcomeUI, inputUI, I18n.t((String)"isisfish.input.title", (Object[])new Object[0]));
    }

    public void newScriptFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, new ScriptUI(), I18n.t((String)"isisfish.script.title", (Object[])new Object[0]));
    }

    public void newSensitivityFrame(WelcomeUI welcomeUI) {
        SensitivityContext sensitivityContext = new SensitivityContext((JAXXContext)welcomeUI);
        SensitivityUI sensitivityUI = new SensitivityUI((JAXXContext)sensitivityContext);
        this.openFrame(welcomeUI, sensitivityUI, I18n.t((String)"isisfish.sensitivity.title", (Object[])new Object[0]));
    }

    public void newQueueFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, (Component)((Object)new QueueUI()), I18n.t((String)"isisfish.queue.title", (Object[])new Object[0]));
    }

    public void close(WelcomeUI welcomeUI) {
        WelcomeSaveVerifier verifier = welcomeUI.getContextValue(WelcomeSaveVerifier.class);
        if (verifier.allIsSaved()) {
            welcomeUI.dispose();
        }
    }

    public void config(WelcomeUI welcomeUI) {
        ConfigUI configUI = new ConfigUI((JAXXContext)welcomeUI, (Frame)welcomeUI, true);
        configUI.pack();
        configUI.setLocationRelativeTo(welcomeUI);
        configUI.setVisible(true);
    }

    public void configurationSSHLauncher(WelcomeUI welcomeUI) {
        SSHLauncherConfigUI configUI = new SSHLauncherConfigUI((JAXXContext)welcomeUI, (Frame)welcomeUI, true);
        configUI.pack();
        configUI.setSize(600, configUI.getHeight());
        configUI.setLocationRelativeTo(welcomeUI);
        configUI.setVisible(true);
    }

    public void configurationR(WelcomeUI welcomeUI) {
        RConfigUI rconfigUI = new RConfigUI((JAXXContext)welcomeUI, (Frame)welcomeUI, true);
        rconfigUI.pack();
        rconfigUI.setLocationRelativeTo(welcomeUI);
        rconfigUI.setVisible(true);
    }

    public void help(WelcomeUI welcomeUI, String urlOrAlias) {
        block3: {
            try {
                String url = URLSALIAS.get(urlOrAlias);
                if (url == null) {
                    url = urlOrAlias;
                }
                Desktop.getDesktop().browse(new URL(url).toURI());
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't show help", (Throwable)e);
            }
        }
    }

    public void about(WelcomeUI welcomeUI) {
        AboutDialog about = new AboutDialog(welcomeUI);
        about.setTitle(I18n.t((String)"isisfish.about.title", (Object[])new Object[0]));
        about.setIconPath("images/isislogo.png");
        about.setAboutHtmlText(I18n.t((String)"isisfish.about.abouthtmltext", (Object[])new Object[]{IsisConfig.getVersion()}));
        about.setLicenseText(I18n.t((String)"isisfish.about.licensetext", (Object[])new Object[0]));
        about.setBackgroundColor(Color.WHITE);
        about.setSize(640, 520);
        about.setLocationRelativeTo(welcomeUI);
        about.setVisible(true);
    }

    static {
        URLSALIAS.put("ISISFISH", IsisFish.config.getIsisFishURL());
        URLSALIAS.put("JAVA_API", IsisFish.config.getJavadocJavaURL());
        URLSALIAS.put("ISIS_API", IsisFish.config.getJavadocIsisURL());
        URLSALIAS.put("MATRIX_API", IsisFish.config.getJavadocMatrixURL());
        URLSALIAS.put("TOPIA_API", IsisFish.config.getJavadocTopiaURL());
    }
}

