/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui;

import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorContext;
import fr.ifremer.isisfish.util.ErrorHelper;
import fr.ifremer.isisfish.util.IsisFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JFileChooser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationHandler {
    private static final Log log = LogFactory.getLog(SimulationHandler.class);
    protected SimulationUI simulationUI;

    public SimulationHandler(SimulationUI simulationUI) {
        this.simulationUI = simulationUI;
    }

    protected SimulationParameter getParameters() {
        return this.simulationUI.getContextValue(SimulationParameter.class);
    }

    public void afterInit() {
        this.simulationUI.addPropertyChangeListener("regionStorage", evt -> this.simulationUI.regionStorageChanged());
        this.simulationUI.setContextValue(this.simulationUI, "SimulationUI");
    }

    public void importSimulation() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this.simulationUI);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.importSimulation(file);
            this.simulationUI.refresh();
        }
    }

    public void saveSimulation() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this.simulationUI);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.saveSimulation(file);
        }
    }

    protected void importSimulation(File f) {
        try (FileInputStream fos = new FileInputStream(f);){
            Properties proper = new Properties();
            proper.load(fos);
            SimulatorContext context = this.simulationUI.getContextValue(SimulatorContext.class, "SimulatorContext");
            context.initDefaultParameters();
            this.getParameters().fromProperties(proper);
            this.getParameters().setExportNames(null);
            this.getParameters().setTagValue(null);
            this.getParameters().setSimulatorName(null);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import simulation", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.simulation.importparameter", (Object[])new Object[0]), e);
        }
    }

    protected void saveSimulation(File f) {
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.getParameters().toProperties().store(fos, null);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save simulation", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.simulation.savesimulation", (Object[])new Object[0]), e);
        }
    }

    public void prepareSimulation() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this.simulationUI);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            file = IsisFileUtil.addExtensionIfNeeded(file, "zip");
            SimulationParameter params = this.getParameters();
            SimulationService.getService().prepareSimulationZipFile(params, file, null, null, null);
        }
    }
}

