/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.migration.DatabaseMigrationClass;
import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.Driver;
import org.hibernate.dialect.H2Dialect;
import org.nuiton.topia.migration.TopiaMigrationEngine;

public class IsisH2Config {
    private static Log log = LogFactory.getLog(IsisH2Config.class);
    protected static Class<?> databaseMigrationClass = DatabaseMigrationClass.class;
    protected static final String COMMON_URL = "DEFAULT_LOCK_TIMEOUT=1000;DB_CLOSE_DELAY=0;LOCK_MODE=3;TRACE_LEVEL_FILE=0;TRACE_LEVEL_SYSTEM_OUT=0";
    protected static final String H2_URL = "jdbc:h2:file:%s;FILE_LOCK=%s;LOG=1;AUTO_SERVER=TRUE;DEFAULT_LOCK_TIMEOUT=1000;DB_CLOSE_DELAY=0;LOCK_MODE=3;TRACE_LEVEL_FILE=0;TRACE_LEVEL_SYSTEM_OUT=0";
    protected static final String H2_MEM_URL = "jdbc:h2:mem:%s;LOG=0;DEFAULT_LOCK_TIMEOUT=1000;DB_CLOSE_DELAY=0;LOCK_MODE=3;TRACE_LEVEL_FILE=0;TRACE_LEVEL_SYSTEM_OUT=0";

    public static File getStorageDataDirectory(File rootDir) {
        return new File(rootDir, "data");
    }

    public static Properties addMemDatabaseConfig(Properties config, String id) {
        config.setProperty("hibernate.connection.username", "sa");
        config.setProperty("hibernate.connection.password", "");
        config.setProperty("hibernate.dialect", H2Dialect.class.getName());
        config.setProperty("hibernate.connection.driver_class", Driver.class.getName());
        config.setProperty("hibernate.current_session_context_class", "thread");
        config.setProperty("hibernate.hikari.connectionTimeout", "20000");
        config.setProperty("hibernate.hikari.minimumIdle", "1");
        config.setProperty("hibernate.hikari.maximumPoolSize", "20");
        config.setProperty("hibernate.hikari.idleTimeout", "300000");
        String url = String.format(H2_MEM_URL, id);
        config.setProperty("hibernate.connection.url", url);
        return config;
    }

    public static Properties addDatabaseConfig(Properties config, File directory) {
        File databasePath = IsisH2Config.getStorageDataDirectory(directory);
        databasePath.mkdirs();
        IsisH2Config.addMemDatabaseConfig(config, "");
        String url = String.format(H2_URL, IsisH2Config.getStorageDataDirectory(databasePath).getPath(), IsisFish.config.getDatabaseLockMode());
        config.setProperty("hibernate.connection.url", url);
        if (log.isDebugEnabled()) {
            log.debug((Object)("hibernate.connection.url = " + url));
        }
        config.put("topia.service.migration", TopiaMigrationEngine.class.getName());
        config.put("topia.service.migration.callback", databaseMigrationClass.getName());
        return config;
    }

    public static Properties addHibernateMapping(Properties config) {
        config.setProperty("topia.persistence.classes", IsisFishDAOHelper.getImplementationClassesAsString());
        return config;
    }
}

