/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.IsisH2Config;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.datastore.VersionStorage;
import fr.ifremer.isisfish.util.IsisFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.util.ZipUtil;

public abstract class DataStorage
extends VersionStorage {
    public static final String DATA_BACKUP_FILENAME = "data-backup.sql.gz";
    private static final Log log = LogFactory.getLog(DataStorage.class);
    protected String name = null;
    protected TopiaContext storage = null;
    protected TopiaContext memstorage = null;
    private File storageDirectory = null;

    protected DataStorage(File directory, String name) {
        super(IsisFish.config.getDatabaseDirectory(), directory);
        this.name = name;
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    protected File getStorageDirectory() {
        if (this.storageDirectory == null) {
            this.storageDirectory = IsisH2Config.getStorageDataDirectory(this.getDirectory());
        }
        return this.storageDirectory;
    }

    protected File getDataBackupFile() {
        File result = new File(this.getDirectory(), DATA_BACKUP_FILENAME);
        return result;
    }

    @Override
    protected void prepare() {
        try {
            File file = this.getDataBackupFile();
            TopiaContext tx = this.getStorage().beginTransaction();
            tx.backup(file, true);
            tx.closeContext();
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.prepare.data", (Object[])new Object[0]), eee);
        }
    }

    @Override
    protected boolean isVersionnableFile(File file) {
        boolean result = super.isVersionnableFile(file);
        if (result) {
            result = !file.equals(this.getStorageDirectory());
        }
        return result;
    }

    public File getDirectory() {
        return this.getFile();
    }

    public String getName() {
        return this.name;
    }

    public TopiaContext getMemStorage() {
        if (this.memstorage == null || this.memstorage.isClosed()) {
            log.info((Object)("Create new memory storage for " + this.getName()));
            try {
                Properties config = new Properties();
                IsisH2Config.addMemDatabaseConfig(config, this.getName());
                IsisH2Config.addHibernateMapping(config);
                this.memstorage = TopiaContextFactory.getContext((Properties)config);
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException("Can't open in memory storage", eee);
            }
            try {
                this.prepare();
                TopiaContext tx = this.memstorage.beginTransaction();
                tx.restore(this.getDataBackupFile());
                tx.commitTransaction();
                tx.closeContext();
            }
            catch (TopiaException eee) {
                throw new IsisFishRuntimeException("Can't populate in memory storage", eee);
            }
        }
        return this.memstorage;
    }

    public void closeMemStorage() throws TopiaException {
        if (this.memstorage != null) {
            this.memstorage.closeContext();
            this.memstorage = null;
        }
    }

    public TopiaContext getStorage() {
        if (this.storage == null || this.storage.isClosed()) {
            log.info((Object)("Create new storage for " + this.getName()));
            try {
                Properties config = new Properties();
                IsisH2Config.addDatabaseConfig(config, this.getDirectory());
                IsisH2Config.addHibernateMapping(config);
                this.storage = TopiaContextFactory.getContext((Properties)config);
            }
            catch (TopiaNotFoundException eee) {
                throw new IsisFishRuntimeException("Can't open storage", eee);
            }
        }
        return this.storage;
    }

    public void closeStorage() throws TopiaException {
        if (this.storage != null) {
            this.storage.closeContext();
            this.storage = null;
        }
    }

    @Override
    public void delete(boolean cvsDelete) throws StorageException {
        try {
            if (this.storage != null) {
                TopiaContext root = this.getStorage();
                root.clear(true);
            }
        }
        catch (TopiaException eee) {
            throw new StorageException(I18n.t((String)"isisfish.error.delete.database", (Object[])new Object[0]), eee);
        }
        super.delete(cvsDelete);
    }

    public void copy(String toName) throws IOException, TopiaException {
        this.prepare();
        File rootDirSrc = this.getDirectory();
        File rootDirDest = new File(rootDirSrc.getParentFile(), toName);
        List<File> files = this.getFiles(false);
        File backupFile = null;
        for (File file : files) {
            if (!file.isFile()) continue;
            String tmp = file.getPath();
            int prefixLength = rootDirSrc.getPath().length();
            tmp = tmp.substring(prefixLength);
            File target = new File(rootDirDest, tmp);
            if (file.equals(this.getDataBackupFile())) {
                backupFile = target;
            }
            FileUtils.copyFile((File)file, (File)target);
        }
        Properties config = new Properties();
        IsisH2Config.addDatabaseConfig(config, rootDirDest);
        IsisH2Config.addHibernateMapping(config);
        TopiaContext tx = TopiaContextFactory.getContext((Properties)config).beginTransaction();
        tx.restore(backupFile);
        tx.commitTransaction();
        tx.closeContext();
    }

    public void rename(String toName) throws StorageException {
        File dir = this.getDirectory();
        File newdir = new File(dir.getParentFile(), toName);
        dir.renameTo(newdir);
    }

    public File createZip() throws IOException {
        File result = IsisFileUtil.createTempFile("isis-" + this.getName(), ".zip");
        result.deleteOnExit();
        this.createZip(result);
        return result;
    }

    public File createZip(File file) throws IOException {
        this.createZip(file, false);
        return file;
    }

    public File createZip(File file, boolean createMD5) throws IOException {
        this.prepare();
        file = IsisFileUtil.addExtensionIfNeeded(file, "zip");
        List<File> files = this.getFiles(false);
        ZipUtil.compressFiles((File)file, (File)this.getDirectory().getParentFile(), files, (boolean)createMD5);
        log.info((Object)("Zip DataStorage in " + String.valueOf(file)));
        return file;
    }

    protected void finalize() throws Throwable {
        try {
            this.closeStorage();
        }
        finally {
            super.finalize();
        }
    }
}

