/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.service.UserService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.validators.EchoBaseFieldValidatorSupport;

public class LoginValidator
extends EchoBaseFieldValidatorSupport {
    public void validateWhenNotSkip(Object object) throws ValidationException {
        EchoBaseActionSupport action = (EchoBaseActionSupport)object;
        UserService userService = (UserService)action.getServiceContext().newService(UserService.class);
        String login = (String)this.getFieldValue("email", object);
        String password = (String)this.getFieldValue("password", object);
        if (this.log.isInfoEnabled()) {
            this.log.info("try to log for user " + login, new String[0]);
        }
        try {
            EchoBaseUser user = userService.getUserByEmail(login);
            if (user == null) {
                this.addFieldError("email", this.translate("echobase.error.login.unknown", new Object[0]));
                return;
            }
            boolean passwordOk = userService.checkPassword(user, password);
            if (!passwordOk) {
                this.addFieldError("password", this.translate("echobase.error.bad.password", new Object[0]));
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not validate login", (Throwable)e, new String[0]);
            }
            throw new ValidationException("Could not validate login : " + e.getMessage());
        }
    }

    public String getValidatorType() {
        return "login";
    }
}

