/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.workingDb;

import fr.ifremer.echobase.entities.EchoBaseUserEntityEnum;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.entities.references.Port;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.services.service.DecoratorService;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.metadata.TableMeta;

public class GetVoyage
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String voyageId;
    protected Map data;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;
    @Inject
    protected transient DecoratorService decoratorService;
    @Inject
    protected transient DbEditorService dbEditorService;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public Map<?, ?> getData() {
        return this.data;
    }

    public String execute() throws Exception {
        TableMeta tableMeta = this.dbEditorService.getTableMeta(EchoBaseUserEntityEnum.Voyage);
        this.data = this.dbEditorService.getData(tableMeta, this.voyageId);
        String missionId = (String)this.data.get("mission");
        Mission mission = this.userDbPersistenceService.getMission(missionId);
        this.decoratorService.decorateForeignKey(this.data, "mission", (TopiaEntity)mission, null);
        String areaOfOperationId = (String)this.data.get("areaOfOperation");
        AreaOfOperation areaOfOperation = this.userDbPersistenceService.getAreaOfOperation(areaOfOperationId);
        this.decoratorService.decorateForeignKey(this.data, "areaOfOperation", (TopiaEntity)areaOfOperation, null);
        String startPortId = (String)this.data.get("startPort");
        Port startPort = this.userDbPersistenceService.getPort(startPortId);
        this.decoratorService.decorateForeignKey(this.data, "startPort", (TopiaEntity)startPort, null);
        String endPortId = (String)this.data.get("endPort");
        Port endPort = this.userDbPersistenceService.getPort(endPortId);
        this.decoratorService.decorateForeignKey(this.data, "endPort", (TopiaEntity)endPort, null);
        return "success";
    }
}

