<%--
  #%L
  EchoBase :: UI
  $Id: showData.jsp 929 2014-01-22 21:32:46Z tchemit $
  $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5.2/echobase-ui/src/main/webapp/WEB-INF/jsp/spatial/showData.jsp $
  %%
  Copyright (C) 2011 - 2013 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<title>
  <s:text name="echobase.title.show.spatial"/>
</title>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:if test="model.withSpatial">

  <script type="text/javascript">

    jQuery(document).ready(function () {

      var getVoyage = $('[name="model.voyageId"]');

      $.autoSelectVoyageAndDataMetadata(
        getVoyage,
        $('[name="model.dataMetadataIdForEsduData"]'),
        '<s:url action="getVoyageDataMetadata" namespace="/spatial"/>',
        '<s:property value="model.voyageId"/>',
        '<s:property value="model.dataMetadataIdForEsduData"/>'
      );

      $.autoSelectVoyageAndDataMetadata(
        getVoyage,
        $('[name="model.dataMetadataIdForEsduResult"]'),
        '<s:url action="getVoyageDataMetadata" namespace="/spatial"/>',
        '<s:property value="model.voyageId"/>',
        '<s:property value="model.dataMetadataIdForEsduResult"/>'
      );

      $.autoSelectVoyageAndDataMetadata(
        getVoyage,
        $('[name="model.dataMetadataIdForMapData"]'),
        '<s:url action="getVoyageDataMetadata" namespace="/spatial"/>',
        '<s:property value="model.voyageId"/>',
        '<s:property value="model.dataMetadataIdForMapData"/>'
      );

      $.autoSelectVoyageAndDataMetadata(
        getVoyage,
        $('[name="model.dataMetadataIdForMapResult"]'),
        '<s:url action="getVoyageDataMetadata" namespace="/spatial"/>',
        '<s:property value="model.voyageId"/>',
        '<s:property value="model.dataMetadataIdForMapResult"/>'
      );

      $.showSpatialLayer("model.showCellEsduDataLayer", "cellEsduDataLayer", "model.dataMetadataIdForEsduData", <s:property value="model.showCellEsduDataLayer"/>);
      $.showSpatialLayer("model.showCellEsduResultLayer", "cellEsduResultLayer", "model.dataMetadataIdForEsduResult", <s:property value="model.showCellEsduResultLayer"/>);
      $.showSpatialLayer("model.showCellMapDataLayer", "cellMapDataLayer", "model.dataMetadataIdForMapData", <s:property value="model.showCellMapDataLayer"/>);
      $.showSpatialLayer("model.showCellMapResultLayer", "cellMapResultLayer", "model.dataMetadataIdForMapResult", <s:property value="model.showCellMapResultLayer"/>);

      var showOptions = function(show) {

        var config = $('#withSelectedVoyage');

        if (show!='') {
          config.show();
        } else {
          config.hide();
        }
      };

      getVoyage.change(function () {
        showOptions(this.value);
      });

      showOptions('<s:property value="model.voyageId"/>');


      <s:if test="model.withData">

      console.info("LOAD DATA!");
      /*
      jQuery.get(
        '<s:url action="displaySpatial" namespace="/spatial"/>',
        {
          "model.voyageId": '<s:property value="model.voyageId"/>',
          "model.dataMetadataIdForEsduData": '<s:property value="model.dataMetadataIdForEsduData"/>',
          "model.dataMetadataIdForEsduResult": '<s:property value="model.dataMetadataIdForEsduResult"/>',
          "model.dataMetadataIdForMapData": '<s:property value="model.dataMetadataIdForMapData"/>',
          "model.dataMetadataIdForMapResult": '<s:property value="model.dataMetadataIdForMapResult"/>',
          "model.showOperationLayer": '<s:property value="model.showOperationLayer"/>',
          "model.showCellEsduDataLayer": '<s:property value="model.showCellEsduDataLayer"/>',
          "model.showCellEsduResultLayer": '<s:property value="model.showCellEsduResultLayer"/>',
          "model.showCellMapDataLayer": '<s:property value="model.showCellMapDataLayer"/>',
          "model.showCellMapResultLayer": '<s:property value="model.showCellMapResultLayer"/>'
        },
        function (result) {

          // inject result
          $('#dataPanel').html(result);
        });*/
      </s:if>
    });
  </script>

  <s:form namespace="/spatial" method="POST" enctype="multipart/form-data">

    <fieldset>
      <legend>
        <s:text name="echobase.legend.showData.configure"/>
      </legend>

      <div class="cleanBoth help">
        <s:a href="%{getDocumentation('showData.html', null)}" target="doc">
          <s:text name="echobase.action.show.showData.documentation"/>
        </s:a>
      </div>
      <br/>

      <s:select key="model.voyageId" requiredLabel="true"
                label='%{getText("echobase.common.voyage")}'
                list="voyages" headerKey="" headerValue=""/>

      <div id="withSelectedVoyage">
        <s:checkbox key="model.showOperationLayer" label='%{getText("echobase.common.showOperationLayer")}'/>

        <s:checkbox key="model.showCellEsduDataLayer" label='%{getText("echobase.common.showCellEsduDataLayer")}'/>
        <div class="cellEsduDataLayer">
          <sj:select key="model.dataMetadataIdForEsduData" requiredLabel="true"
                     label='%{getText("echobase.common.dataMetadata.forEsduDataLayer")}'
                     headerKey="" headerValue=""/>
        </div>

        <s:checkbox key="model.showCellEsduResultLayer" label='%{getText("echobase.common.showCellEsduResultLayer")}'/>
        <div class="cellEsduResultLayer">
          <sj:select key="model.dataMetadataIdForEsduResult" requiredLabel="true"
                     label='%{getText("echobase.common.dataMetadata.forEsduResultLayer")}'
                     headerKey="" headerValue=""/>
        </div>

        <s:checkbox key="model.showCellMapDataLayer" label='%{getText("echobase.common.showCellMapDataLayer")}'/>
        <div class="cellMapDataLayer">
          <sj:select key="model.dataMetadataIdForMapData" requiredLabel="true"
                     label='%{getText("echobase.common.dataMetadata.forMapDataLayer")}'
                     headerKey="" headerValue=""/>
        </div>
        <s:checkbox key="model.showCellMapResultLayer" label='%{getText("echobase.common.showCellMapResultLayer")}'/>
        <div class="cellMapResultLayer">
          <sj:select key="model.dataMetadataIdForMapResult" requiredLabel="true"
                     label='%{getText("echobase.common.dataMetadata.forMapResultLayer")}'
                     headerKey="" headerValue=""/>
        </div>

      </div>

      <s:hidden key="model.withData" label=' '/>
      <s:hidden key="model.withSpatial" label=' '/>

    </fieldset>
    <br/>

    <div class="toolbar">
      <ul class="toolbar floatRight">
        <li>
          <s:submit action='reconfigure' key="echobase.action.reset"/>
        </li>
        <li>
          <s:submit action='save' key="echobase.action.save"/>
        </li>
        <li>
          <s:submit action="showSpatial" key='echobase.action.display'/>
        </li>
      </ul>
    </div>

    <s:if test="model.withData">

      <fieldset>
        <legend>
          <s:text name="echobase.legend.showData.result"/>
        </legend>

        <div id="dataPanel">
          <center>Loading...</center>
        </div>
      </fieldset>
    </s:if>

  </s:form>
</s:if>
<s:else>

  <p>
    <s:text name="echobase.message.no.spatial.database.support"/>
  </p>

  <s:if test="canAddSpatial">
    <br/>
    <s:form id="createForm" namespace="/spatial">
      <ul class="toolbar floatLeft">

        <li>
          <s:submit theme="simple" action="addSpatial"
                    key="echobase.action.workingDbconfiguration.addSpatial"/>
        </li>

      </ul>
    </s:form>
  </s:if>
</s:else>


