/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.service.UserService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;

public class Update
extends EchoBaseActionSupport
implements Preparable,
ParameterAware {
    protected static final Log log = LogFactory.getLog(Update.class);
    private static final long serialVersionUID = 1L;
    protected EchoBaseUser user;
    private transient Map<String, String[]> parameters;
    @Inject
    protected transient UserService userService;

    public EchoBaseUser getUser() {
        if (this.user == null) {
            this.user = this.userService.newUser();
        }
        return this.user;
    }

    public String execute() throws Exception {
        EchoBaseUser userToUpdate = this.getUser();
        String userEmail = userToUpdate.getEmail();
        if (log.isInfoEnabled()) {
            log.info((Object)("will update user " + userEmail));
        }
        this.userService.createOrUpdate(userToUpdate);
        this.addFlashMessage(this._("echobase.info.user.update", new Object[]{userEmail}));
        return "success";
    }

    public void prepare() throws Exception {
        String userId = ((String[])this.parameters.get("user.topiaId"))[0];
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            this.user = this.userService.getUserById(userId);
            this.user.setPassword("");
            if (log.isInfoEnabled()) {
                log.info((Object)("Selected user " + this.user.getEmail()));
            }
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }
}

