/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: CheckUserIsAdmin.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/interceptors/CheckUserIsAdmin.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.interceptors;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionInvocation;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.ui.EchoBaseSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * To check if logged user is admin.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class CheckUserIsAdmin extends AbstractCheckInterceptor {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(CheckUserIsAdmin.class);

    @Override
    protected boolean doCheck(ActionInvocation invocation) {
        EchoBaseSession echoBaseSession = EchoBaseSession.getEchoBaseSession(
                invocation.getInvocationContext());

        EchoBaseUser user = echoBaseSession.getUser();
        Preconditions.checkNotNull(user, "No user found is session");

        boolean admin = user.isAdmin();
        if (!admin) {
            if (log.isDebugEnabled()) {
                log.debug("User is not admin, will redirect to home");
            }
        }
        return admin;
    }
}
