/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: AbstractConfigureImport.java 420 2012-03-27 23:02:51Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/AbstractConfigureImport.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.InputFile;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.FileUtil;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * Configure a accoustic data import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public abstract class AbstractConfigureImport<M extends AbstractImportConfiguration> extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(AbstractConfigureImport.class);

    protected final Class<M> modelType;

    protected M model;

    protected AbstractConfigureImport(Class<M> modelType) {
        this.modelType = modelType;
    }

    public final M getModel() {
        if (model == null) {
            model = createModel();
        }
        return model;
    }

    protected abstract M createModel();

    @Override
    public String input() throws Exception {

        // always remove configuration from session anytime coming here
        getEchoBaseSession().removeImportDataConfiguration(modelType);

        return INPUT;
    }

    @InputConfig(methodName = "input")
    @Override
    public String execute() throws Exception {

        M importModel = getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(
                tempDirectory,
                "echobase-importData-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary(dataDirectory);
        importModel.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info("Temporary directory to use : " + dataDirectory);
        }

        for (InputFile inputFile : importModel.getInputFiles()) {
            if (inputFile.hasFile()) {
                copyFile(inputFile, dataDirectory);
            }
        }
        setInSession(importModel);
        return SUCCESS;
    }


    protected final void setInSession(M model) {
        getEchoBaseSession().setImportDataConfiguration(model);
    }

    protected final M getFromSession() {
        return getEchoBaseSession().getImportDataConfiguration(modelType);
    }

    public final void setModel(M model) {
        this.model = model;
    }

    protected <E extends TopiaEntity> Map<String, String> loadSortAndDecorate(EchoBaseServiceSupport service, Class<E> beanType) {

        List<E> beans = service.getEntities(beanType);
        return getDecoratorService().sortAndDecorate(getLocale(), beans, null);
    }
}
