/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConfigureCommonData.java 333 2012-03-01 22:45:19Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ConfigureCommonData.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.configurations.CommonDataImportConfiguration;
import fr.ifremer.echobase.services.configurations.CommonDataImportMode;

import java.io.File;
import java.util.Map;

/**
 * Configure a accoustic data import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class ConfigureCommonData extends AbstractConfigureImport<CommonDataImportConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Universe of existing missions. */
    protected Map<String, String> missions;

    /** Universe of existing voyages. */
    protected Map<String, String> voyages;

    /** Universe of existing area of operations. */
    protected Map<String, String> areaOfOperations;

    /** Universe of possible import modes. */
    protected Map<String, String> importModes;

    public ConfigureCommonData() {
        super(CommonDataImportConfiguration.class);
    }

    @Override
    protected CommonDataImportConfiguration createModel() {
        return new CommonDataImportConfiguration(getLocale());
    }

    @Override
    public String input() throws Exception {

        super.input();

        EchoBaseServiceSupport service =
                newService(EchoBaseServiceSupport.class);

        missions = loadSortAndDecorate(service, Mission.class);
        voyages = loadSortAndDecorate(service, Voyage.class);
        areaOfOperations = loadSortAndDecorate(service, AreaOfOperation.class);
        importModes = decorateEnums(CommonDataImportMode.values());

        if (getModel().getImportMode() == null) {

            getModel().setImportMode(CommonDataImportMode.ALL);
        }

        return INPUT;
    }

    @InputConfig(methodName = "input")
    public String modeAll() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeTransect() throws Exception {

        return execute();
    }

    public Map<String, String> getMissions() {
        return missions;
    }

    public Map<String, String> getVoyages() {
        return voyages;
    }

    public Map<String, String> getAreaOfOperations() {
        return areaOfOperations;
    }

    public Map<String, String> getImportModes() {
        return importModes;
    }

    public void setVoyageFile(File file) {
        getModel().getVoyageFile().setFile(file);
    }

    public void setVoyageFileContentType(String contentType) {
        getModel().getVoyageFile().setContentType(contentType);
    }

    public void setVoyageFileFileName(String fileName) {
        getModel().getVoyageFile().setFileName(fileName);
    }

    public void setTransitFile(File file) {
        getModel().getTransitFile().setFile(file);
    }

    public void setTransitFileContentType(String contentType) {
        getModel().getTransitFile().setContentType(contentType);
    }

    public void setTransitFileFileName(String fileName) {
        getModel().getTransitFile().setFileName(fileName);
    }

    public void setTransectFile(File file) {
        getModel().getTransectFile().setFile(file);
    }

    public void setTransectFileContentType(String contentType) {
        getModel().getTransectFile().setContentType(contentType);
    }

    public void setTransectFileFileName(String fileName) {
        getModel().getTransectFile().setFileName(fileName);
    }

}
