/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: SaveEntity.java 55 2011-11-13 22:22:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/SaveEntity.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.meta.TableMeta;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.ParameterAware;
import org.nuiton.util.beans.PropertyDiff;

import java.util.List;
import java.util.Map;

/**
 * Save the edition of a row of a table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SaveEntity extends EchoBaseActionSupport implements ParameterAware {

    private static final long serialVersionUID = 1L;

    /** Name of the table to load. */
    protected String tableName;

    /** id of entity to save. */
    protected String id;

    /** Metas of the table */
    protected TableMeta tableMeta;

    protected Map<String, String[]> params;

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String execute() throws Exception {

        DbEditorService dbEditorService = newService(DbEditorService.class);
        TableMeta tableMeta = dbEditorService.getTableMetas(tableName);
        Map<String, String> properties = Maps.newHashMap();
        List<String> columnNames = tableMeta.getColumnNames();
        for (String columnName : columnNames) {
            if (params.containsKey(columnName)) {

                // there is a such property to edit
                String[] values = params.get(columnName);

                if (values.length > 0) {

                    // take only the first value
                    String propertyValue = values[0];
                    if (StringUtils.isNotEmpty(propertyValue)) {

                        // only keep properties with no empty value
                        properties.put(columnName, propertyValue);
                    }
                }
            }
        }

        PropertyDiff[] diffs =
                dbEditorService.saveEntity(tableMeta,
                                           id,
                                           properties,
                                           getEchoBaseSession().getEchoBaseUser());

        for (PropertyDiff diff : diffs) {
            addActionMessage(_("echobase.message.modified.property",
                               diff.getSourceProperty(),
                               diff.getSourceValue(),
                               diff.getTargetValue())
            );
        }
        return NONE;
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) {
        params = Maps.newHashMap();
        params.putAll(parameters);
    }

}

