/*
 * #%L
 * 
 * 
 * $Id: OtherDataFileListModel.java 505 2011-01-14 14:05:29Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.1/coser-ui/src/main/java/fr/ifremer/coser/ui/result/OtherDataFileListModel.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.result;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractListModel;

/**
 * Modele de list pour la list des fichiers et répertoire des fichiers
 * additionnels.
 * 
 * @author chatellier
 * @version $Revision: 505 $
 * 
 * Last update : $Date: 2011-01-14 15:05:29 +0100 (Fri, 14 Jan 2011) $
 * By : $Author: chatellier $
 */
public class OtherDataFileListModel extends AbstractListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8652851018076968539L;

    protected List<File> otherFiles;

    public OtherDataFileListModel() {
        otherFiles = new ArrayList<File>();
    }

    public List<File> getOtherFiles() {
        return otherFiles;
    }

    public void add(File file) {
        otherFiles.add(file);
        fireIntervalAdded(this, otherFiles.size() - 1, otherFiles.size() - 1);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        return otherFiles.size();
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return otherFiles.get(index);
    }
}
