package fr.ifremer.coselmar.services;

/*
 * #%L
 * Coselmar :: Rest Services
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Date;
import java.util.Locale;

import fr.ifremer.coselmar.persistence.CoselmarPersistenceContext;
import fr.ifremer.coselmar.persistence.entity.DocumentTopiaDao;
import fr.ifremer.coselmar.persistence.entity.UserTopiaDao;
import fr.ifremer.coselmar.services.config.CoselmarServicesConfig;
import fr.ifremer.coselmar.services.v1.DocumentsWebService;
import org.debux.webmotion.server.WebMotionController;
import org.debux.webmotion.server.call.HttpContext;

/**
 * @author ymartel <martel@codelutin.com>
 */
public abstract class CoselmarWebServiceSupport extends WebMotionController implements CoselmarService {

    private CoselmarServicesContext servicesContext;

    @Override
    public void setServicesContext(CoselmarServicesContext servicesContext) {
        this.servicesContext = servicesContext;
    }

    protected CoselmarServicesContext getServicesContext() {
        //try to get it from Request context
        HttpContext context = getContext();
        if (context != null) {
            CoselmarRestRequestContext requestContext = CoselmarRestRequestContext.getRequestContext(context);
            this.servicesContext = requestContext.getServicesContext();
        }
        return this.servicesContext;
    }

    // Delegate serviceContext //

    protected Date getNow() {
        return getServicesContext().getNow();
    }

    protected String getCleanMail(String email) {
        return getServicesContext().getCleanMail(email);
    }

    protected CoselmarPersistenceContext getPersistenceContext() {
        return getServicesContext().getPersistenceContext();
    }

    protected CoselmarServicesConfig getCoselmarServicesConfig() {
        return getServicesContext().getCoselmarServicesConfig();
    }

    protected Locale getLocale() {
        return servicesContext.getLocale();
    }

    // Services //

    public DocumentsWebService getDocumentsService() {
        return newService(DocumentsWebService.class);
    }

    protected <E extends CoselmarService> E newService(Class<E> serviceClass) {
        return getServicesContext().newService(serviceClass);
    }

    // Persistence //
    protected DocumentTopiaDao getDocumentDao() {
        return getPersistenceContext().getDocumentDao();
    }

    protected UserTopiaDao getUserDao() {
        return getPersistenceContext().getUserDao();
    }

    public void commit() {
        getPersistenceContext().commit();
    }

    public void rollback() {
        getPersistenceContext().rollback();
    }
}
