/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.beans.UserWebToken;
import fr.ifremer.coselmar.converter.BeanEntityConverter;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.Privacy;
import fr.ifremer.coselmar.services.CoselmarTechnicalException;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.errors.InvalidCredentialException;
import fr.ifremer.coselmar.services.errors.UnauthorizedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.call.UploadFile;
import org.debux.webmotion.server.render.Render;
import org.nuiton.topia.persistence.TopiaNoResultException;
import org.nuiton.util.DateUtil;

public class DocumentsWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(DocumentsWebService.class);
    public static final List<String> DOCUMENT_EDIT_ALLOWED_USER_ROLES = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.EXPERT.name(), CoselmarUserRole.SUPERVISOR.name()});
    public static final List<String> DOCUMENT_VIEW_ALLOWED_USER_ROLES = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.ADMIN.name(), CoselmarUserRole.SUPERVISOR.name(), CoselmarUserRole.EXPERT.name()});

    public DocumentBean getDocument(String documentId) throws InvalidCredentialException, UnauthorizedException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String fullId = this.getDocumentFullId(documentId);
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        if (!this.isAllowedToAccessDocument(userWebToken, document)) {
            String message = String.format("User %s %s ('%s') try to access to document '%s'", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId(), documentId);
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        DocumentBean documentBean = BeanEntityConverter.toBean((String)documentId, (Document)document);
        return documentBean;
    }

    public List<DocumentBean> getDocuments(List<String> searchKeywords) throws InvalidCredentialException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String fullCurrentUserId = this.getFullUserIdFromShort(userWebToken.getUserId());
        CoselmarUser currentUser = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullCurrentUserId).findAnyOrNull();
        String currentUserRole = userWebToken.getRole().toUpperCase();
        List documentList = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.ADMIN.name(), CoselmarUserRole.SUPERVISOR.name()}).contains(currentUserRole) ? this.findAllDocuments(searchKeywords) : this.getDocumentDao().findAllFilterByUser(currentUser, searchKeywords);
        ArrayList<DocumentBean> result = new ArrayList<DocumentBean>(documentList.size());
        for (Document document : documentList) {
            String lightId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(document.getTopiaId());
            DocumentBean documentBean = BeanEntityConverter.toBean((String)lightId, (Document)document);
            result.add(documentBean);
        }
        return result;
    }

    public DocumentBean addDocument(DocumentBean document, UploadFile uploadFile) throws InvalidCredentialException, UnauthorizedException {
        CoselmarUser owner;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String userRole = userWebToken.getRole();
        if (!DOCUMENT_EDIT_ALLOWED_USER_ROLES.contains(userRole.toUpperCase())) {
            String message = String.format("User %s %s ('%s') is not allowed to add document", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        Preconditions.checkNotNull((Object)document);
        String fullId = this.getFullUserIdFromShort(userWebToken.getUserId());
        try {
            owner = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findUnique();
        }
        catch (TopiaNoResultException tnre) {
            String message = String.format("Seems that logged user ('%s') does not exist anymore.", fullId);
            if (log.isErrorEnabled()) {
                log.equals(message);
            }
            throw new CoselmarTechnicalException(message);
        }
        String documentName = document.getName();
        String contentType = null;
        if (document.isWithFile()) {
            contentType = this.managerDocumentFile(uploadFile, owner);
        }
        Document documentEntity = (Document)this.getDocumentDao().create();
        documentEntity.setOwner(owner);
        documentEntity.setName(documentName);
        documentEntity.setPrivacy(Privacy.valueOf((String)document.getPrivacy().toUpperCase()));
        documentEntity.addAllKeywords((Collection)document.getKeywords());
        Date depositDate = document.getDepositDate();
        if (depositDate != null) {
            documentEntity.setDepositDate(new Date(depositDate.getTime()));
        } else {
            documentEntity.setDepositDate(new Date());
        }
        documentEntity.setType(document.getType());
        documentEntity.setSummary(document.getSummary());
        documentEntity.setLanguage(document.getLanguage());
        documentEntity.setPublicationDate(document.getPublicationDate());
        documentEntity.setAuthors(document.getAuthors());
        documentEntity.setCopyright(document.getCopyright());
        documentEntity.setLicense(document.getLicense());
        if (document.isWithFile()) {
            documentEntity.setWithFile(true);
            documentEntity.setMimeType(contentType);
        } else {
            documentEntity.setWithFile(false);
            documentEntity.setExternalUrl(document.getExternalUrl());
        }
        this.commit();
        String lightId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(documentEntity.getTopiaId());
        DocumentBean result = BeanEntityConverter.toBean((String)lightId, (Document)documentEntity);
        return result;
    }

    public Render getDocumentFile(String documentId) {
        String fullId = this.getDocumentFullId(documentId);
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        File documentFile = this.getDocumentFile(document);
        String fileName = document.getName();
        String fileMimeType = document.getMimeType();
        try {
            FileInputStream fileStream = new FileInputStream(documentFile);
            return this.renderDownload((InputStream)fileStream, fileName, fileMimeType);
        }
        catch (FileNotFoundException e) {
            if (log.isErrorEnabled()) {
                String message = String.format("Unable to retrieve file %s", fileName);
                log.error((Object)message);
            }
            throw new CoselmarTechnicalException("File does not exist");
        }
    }

    public void saveDocument(DocumentBean documentBean) {
        throw new CoselmarTechnicalException("not yet implemented");
    }

    public void deleteDocument(String documentId) throws InvalidCredentialException, UnauthorizedException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String fullId = this.getDocumentFullId(documentId);
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        if (!this.isAllowedToAccessDocument(userWebToken, document)) {
            String message = String.format("User %s %s ('%s') try to delete document '%s'", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId(), documentId);
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        if (document.isWithFile()) {
            File documentFile = this.getDocumentFile(document);
            FileUtils.deleteQuietly((File)documentFile);
        }
        this.getDocumentDao().delete(document);
        this.commit();
    }

    protected String managerDocumentFile(UploadFile uploadFile, CoselmarUser owner) {
        Preconditions.checkNotNull((Object)uploadFile);
        String fileName = uploadFile.getName();
        File uploadedFile = uploadFile.getFile();
        String contentType = uploadFile.getContentType();
        if (log.isInfoEnabled()) {
            String message = String.format("File name : %s, content-type : %s", fileName, contentType);
            log.info((Object)message);
        }
        String userPath = this.getUserDocumentPath(owner);
        Date now = this.getNow();
        String formattedDay = DateUtil.formatDate((Date)now, (String)"yyyymmdd");
        String prefix = formattedDay + "-";
        File destFile = new File(userPath + File.separator + prefix + fileName);
        try {
            FileUtils.moveFile((File)uploadedFile, (File)destFile);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error during File transfer", (Throwable)e);
            }
            throw new CoselmarTechnicalException("Internal error during file transfer");
        }
        return contentType;
    }

    protected String getUserDocumentPath(CoselmarUser user) {
        File dataDirectory = this.getCoselmarServicesConfig().getDataDirectory();
        String absolutePath = dataDirectory.getAbsolutePath();
        String userFolder = StringUtils.replaceChars((String)(user.getFirstname() + "-" + user.getName()), (String)" ", (String)"_");
        String userPath = absolutePath + File.separator + userFolder;
        return userPath;
    }

    protected File getDocumentFile(Document document) {
        String fileName = document.getName();
        Date depositeDate = document.getDepositDate();
        String userDocumentPath = this.getUserDocumentPath(document.getOwner());
        String formatedDay = DateUtil.formatDate((Date)depositeDate, (String)"yyyymmdd");
        String prefix = formatedDay + "-";
        return new File(userDocumentPath + "/" + prefix + fileName);
    }

    protected boolean isAllowedToAccessDocument(UserWebToken userWebToken, Document document) {
        boolean isAuthorized = false;
        String viewerRole = userWebToken.getRole().toUpperCase();
        if (document.getPrivacy() == Privacy.PUBLIC) {
            isAuthorized = DOCUMENT_VIEW_ALLOWED_USER_ROLES.contains(viewerRole);
        } else if (document.getPrivacy() == Privacy.PRIVATE) {
            CoselmarUser documentOwner = document.getOwner();
            boolean isOwner = StringUtils.equals((CharSequence)documentOwner.getTopiaId(), (CharSequence)this.getFullUserIdFromShort(userWebToken.getUserId()));
            isAuthorized = isOwner || Lists.newArrayList((Object[])new String[]{CoselmarUserRole.ADMIN.name(), CoselmarUserRole.SUPERVISOR.name()}).contains(viewerRole);
        }
        return isAuthorized;
    }

    protected String getDocumentFullId(String documentId) {
        return Document.class.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + documentId;
    }

    protected List<Document> findAllDocuments(List<String> searchKeywords) {
        List documentList = searchKeywords != null && !searchKeywords.isEmpty() ? this.getDocumentDao().findAllContainingAllKeywords(searchKeywords) : this.getDocumentDao().findAll();
        return documentList;
    }
}

