/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services;

import fr.ifremer.coselmar.persistence.CoselmarPersistenceContext;
import fr.ifremer.coselmar.persistence.CoselmarTopiaApplicationContext;
import fr.ifremer.coselmar.services.CoselmarService;
import fr.ifremer.coselmar.services.CoselmarServicesContext;
import fr.ifremer.coselmar.services.CoselmarTechnicalException;
import fr.ifremer.coselmar.services.config.CoselmarServicesConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DefaultCoselmarServicesContext
implements CoselmarServicesContext {
    protected CoselmarServicesConfig servicesConfig;
    protected CoselmarPersistenceContext persistenceContext;
    protected Locale locale;
    private CoselmarTopiaApplicationContext topiaApplicationContext;

    public void setCoselmarServicesConfig(CoselmarServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setTopiaApplicationContext(CoselmarTopiaApplicationContext topiaApplicationContext) {
        this.topiaApplicationContext = topiaApplicationContext;
    }

    public void setPersistenceContext(CoselmarPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Date getNow() {
        Date now = new Date();
        return now;
    }

    public CoselmarTopiaApplicationContext getTopiaApplicationContext() {
        return this.topiaApplicationContext;
    }

    public CoselmarPersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public CoselmarServicesConfig getCoselmarServicesConfig() {
        return this.servicesConfig;
    }

    public <E extends CoselmarService> E newService(Class<E> serviceClass) {
        CoselmarService service;
        try {
            Constructor<E> constructor = serviceClass.getConstructor(new Class[0]);
            service = (CoselmarService)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CoselmarTechnicalException("all services must provide a default public constructor", (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CoselmarTechnicalException("unable to instantiate coselmar service", (Throwable)e);
        }
        service.setServicesContext((CoselmarServicesContext)this);
        return (E)service;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public String getCleanMail(String email) {
        return email == null ? null : StringUtils.lowerCase((String)email.trim());
    }
}

