/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import de.undercouch.bson4jackson.io.StaticBuffers;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class StaticBufferedInputStream
extends BufferedInputStream {
    private static final StaticBuffers.Key BUFFER_KEY = StaticBuffers.Key.BUFFER1;
    private final StaticBuffers _staticBuffers = StaticBuffers.getInstance();
    private ByteBuffer _byteBuffer;

    public StaticBufferedInputStream(InputStream in) {
        this(in, 8192);
    }

    public StaticBufferedInputStream(InputStream in, int size) {
        super(in, 1);
        this._byteBuffer = this._staticBuffers.byteBuffer(BUFFER_KEY, size);
        this.buf = this._byteBuffer.array();
    }

    @Override
    public void close() throws IOException {
        this._staticBuffers.releaseByteBuffer(BUFFER_KEY, this._byteBuffer);
        super.close();
    }
}

