/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.bytez.malloc;

import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import org.nustaq.offheap.bytez.malloc.MemoryBytez;

public class MMFBytez
extends MemoryBytez {
    private File file;
    private ResourceScope scope;

    public MMFBytez(String filePath, long length, boolean clearFile) throws Exception {
        this.init(filePath, length, clearFile);
    }

    protected void init(String file, long length, boolean clearFile) throws Exception {
        File f = new File(file);
        if (f.exists() && clearFile) {
            f.delete();
        }
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        this.scope = ResourceScope.newSharedScope();
        this.memseg = MemorySegment.mapFile((Path)f.toPath(), (long)0L, (long)length, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (ResourceScope)this.scope);
        this.file = f;
    }

    public void freeAndClose() {
        this.scope.close();
    }

    public File getFile() {
        return this.file;
    }
}

