/*
 * Decompiled with CFR 0.152.
 */
package de.jutzig.github.release.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class UploadMojo
extends AbstractMojo
implements Contextualizable {
    private String serverId;
    private String tag;
    private String releaseName;
    private String description;
    private String repositoryId;
    private Settings settings;
    private MavenSession session;
    private String artifact;
    private FileSet fileSet;
    private List<FileSet> fileSets;
    private Boolean overwriteArtifact;
    @Requirement
    private PlexusContainer container;
    private Boolean prerelease;
    private static final Pattern REPOSITORY_PATTERN = Pattern.compile("^(scm:git[:|])?(https?://github\\.com/|git@github\\.com:)([^/]+/[^/]*?)(\\.git)?$", 2);

    public void execute() throws MojoExecutionException {
        if (this.releaseName == null) {
            this.releaseName = this.tag;
        }
        if (this.prerelease == null) {
            this.prerelease = this.tag.endsWith("-SNAPSHOT");
        }
        this.repositoryId = UploadMojo.computeRepositoryId(this.repositoryId);
        GHRelease release = null;
        try {
            GitHub gitHub = this.createGithub(this.serverId);
            GHRepository repository = gitHub.getRepository(this.repositoryId);
            release = this.findRelease(repository, this.releaseName);
            if (release == null) {
                this.getLog().info((CharSequence)("Creating release " + this.releaseName));
                GHReleaseBuilder builder = repository.createRelease(this.tag);
                if (this.description != null) {
                    builder.body(this.description);
                }
                builder.prerelease(this.prerelease.booleanValue());
                builder.name(this.releaseName);
                release = builder.create();
            } else {
                this.getLog().info((CharSequence)("Release " + this.releaseName + " already exists. Not creating"));
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create release", (Exception)e);
        }
        try {
            File asset;
            if (this.artifact != null && !this.artifact.trim().isEmpty() && (asset = new File(this.artifact)).exists()) {
                this.uploadAsset(release, asset);
            }
            if (this.fileSet != null) {
                this.uploadAssets(release, this.fileSet);
            }
            if (this.fileSets != null) {
                for (FileSet set : this.fileSets) {
                    this.uploadAssets(release, set);
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to upload assets", (Exception)e);
        }
    }

    private void uploadAsset(GHRelease release, File asset) throws IOException {
        this.getLog().info((CharSequence)("Processing asset " + asset.getPath()));
        URL url = new URL(MessageFormat.format("https://uploads.github.com/repos/{0}/releases/{1}/assets?name={2}", this.repositoryId, Long.toString(release.getId()), asset.getName()));
        List existingAssets = release.getAssets();
        for (GHAsset a : existingAssets) {
            if (!a.getName().equals(asset.getName())) continue;
            if (this.overwriteArtifact.booleanValue()) {
                this.getLog().info((CharSequence)"  Deleting existing asset");
                a.delete();
                continue;
            }
            this.getLog().warn((CharSequence)("Asset " + asset.getName() + " already exists. Skipping"));
            return;
        }
        this.getLog().info((CharSequence)"  Upload asset");
        release.uploadAsset(asset, "application/zip");
    }

    private void uploadAssets(GHRelease release, FileSet fileset) throws IOException {
        List assets = FileUtils.getFiles((File)new File(fileset.getDirectory()), (String)StringUtils.join((Collection)fileset.getIncludes(), (char)','), (String)StringUtils.join((Collection)fileset.getExcludes(), (char)','));
        for (File asset : assets) {
            this.uploadAsset(release, asset);
        }
    }

    private GHRelease findRelease(GHRepository repository, String releaseName2) throws IOException {
        List releases = repository.getReleases();
        for (GHRelease ghRelease : releases) {
            if (!ghRelease.getName().equals(releaseName2)) continue;
            return ghRelease;
        }
        return null;
    }

    public static String computeRepositoryId(String id) {
        Matcher matcher = REPOSITORY_PATTERN.matcher(id);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return id;
    }

    public GitHub createGithub(String serverId) throws MojoExecutionException, IOException {
        String usernameProperty = System.getProperty("username");
        String passwordProperty = System.getProperty("password");
        if (usernameProperty != null && passwordProperty != null) {
            this.getLog().debug((CharSequence)"Using server credentials from system properties 'username' and 'password'");
            return GitHub.connectUsingPassword((String)usernameProperty, (String)passwordProperty);
        }
        Server server = this.getServer(this.settings, serverId);
        if (server == null) {
            throw new MojoExecutionException(MessageFormat.format("Server ''{0}'' not found in settings", serverId));
        }
        this.getLog().debug((CharSequence)MessageFormat.format("Using ''{0}'' server credentials", serverId));
        try {
            SettingsDecrypter settingsDecrypter = (SettingsDecrypter)this.container.lookup(SettingsDecrypter.class);
            SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            server = result.getServer();
        }
        catch (ComponentLookupException cle) {
            throw new MojoExecutionException("Unable to lookup SettingsDecrypter: " + cle.getMessage(), (Exception)((Object)cle));
        }
        String serverUsername = server.getUsername();
        String serverPassword = server.getPassword();
        String serverAccessToken = server.getPrivateKey();
        if (StringUtils.isNotEmpty((String)serverUsername) && StringUtils.isNotEmpty((String)serverPassword)) {
            return GitHub.connectUsingPassword((String)serverUsername, (String)serverPassword);
        }
        if (StringUtils.isNotEmpty((String)serverAccessToken)) {
            return GitHub.connectUsingOAuth((String)serverAccessToken);
        }
        throw new MojoExecutionException("Configuration for server " + serverId + " has no login credentials");
    }

    protected Server getServer(Settings settings, String serverId) {
        if (settings == null) {
            return null;
        }
        List servers = settings.getServers();
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        for (Server server : servers) {
            if (!serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

