/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.paint;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.paint.AbstractPaint;

public class ColorPaint
extends AbstractPaint {
    private float alphaValue;
    private PDColorSpace pdColorSpace;
    private float[] colorValues;

    protected ColorPaint(ColorPaint colorPaint) {
        this.alphaValue = colorPaint.alphaValue;
        this.colorValues = colorPaint.colorValues;
        this.pdColorSpace = colorPaint.pdColorSpace;
    }

    public ColorPaint(PDColorSpace pDColorSpace) {
        this.pdColorSpace = pDColorSpace;
        this.alphaValue = 1.0f;
    }

    public IPaint copy() {
        return new ColorPaint(this);
    }

    public float getAlphaValue() {
        return this.alphaValue;
    }

    public float[] getColorValues() {
        return this.colorValues;
    }

    public PDColorSpace getPdColorSpace() {
        return this.pdColorSpace;
    }

    public void setAlphaValue(float f) {
        this.alphaValue = f;
    }

    public void setBackgroundPaintFromGraphicsContext(IGraphicsContext iGraphicsContext) {
        IGraphicsEnvironmentAdapter iGraphicsEnvironmentAdapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(iGraphicsContext.getGraphicsEnvironment());
        iGraphicsEnvironmentAdapter.setBackgroundColorPaint(iGraphicsContext, this);
    }

    public void setColorValues(float[] fArray) {
        this.colorValues = fArray;
    }

    public void setForegroundPaintFromGraphicsContext(IGraphicsContext iGraphicsContext) {
        IGraphicsEnvironmentAdapter iGraphicsEnvironmentAdapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(iGraphicsContext.getGraphicsEnvironment());
        iGraphicsEnvironmentAdapter.setForegroundColorPaint(iGraphicsContext, this);
    }
}

