/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.paint;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;

/**
 * A pattern {@link IPaint} implementation.
 * 
 */
public class PatternPaint extends AbstractPaint {
	float alphaValue;

	float[] colorValues;

	PDPattern pattern;

	public PatternPaint() {
		super();

		alphaValue = 1.0f;
	}

	public IPaint copy() {
		PatternPaint copy;

		copy = new PatternPaint();
		copy.alphaValue = alphaValue;
		copy.colorValues = colorValues;
		copy.pattern = pattern;

		return copy;
	}

	public float getAlphaValue() {
		return alphaValue;
	}

	public PDPattern getPdPattern() {
		return pattern;
	}

	public void setAlphaValue(float value) {
		alphaValue = value;
	}

	public void setBackgroundPaintFromGraphicsContext(
			IGraphicsContext graphicsContext) {
		IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry
				.get().lookupGraphicsEnvironmentAdapter(
						graphicsContext.getGraphicsEnvironment());
		adapter.setBackgroundPatternPaint(graphicsContext, this);
	}

	public void setForegroundPaintFromGraphicsContext(
			IGraphicsContext graphicsContext) {
		IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry
				.get().lookupGraphicsEnvironmentAdapter(
						graphicsContext.getGraphicsEnvironment());
		adapter.setForegroundPatternPaint(graphicsContext, this);
	}

	public void setPatternValues(float[] paramColorValues,
			PDPattern paramPattern) {
		colorValues = paramColorValues;
		pattern = paramPattern;
	}

}
