/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.image;

import java.util.Iterator;

import de.intarsys.tools.provider.ProviderTools;

/**
 * 
 */
public class PlatformImageFactory {

	/** The default factory. */
	private static IPlatformImageFactory Unique;

	static private boolean lookupProviders = true;

	static protected IPlatformImageFactory findProviders() {
		Iterator<IPlatformImageFactory> ps = ProviderTools
				.providers(IPlatformImageFactory.class);
		while (ps.hasNext()) {
			try {
				return ps.next();
			} catch (Throwable e) {
				// ignore and try on
			}
		}
		return null;
	}

	/**
	 * Return the unique factory.
	 * 
	 * @return Return the unique factory.
	 */
	synchronized static public IPlatformImageFactory get() {
		if (Unique == null) {
			init();
		}
		return Unique;
	}

	static protected void init() {
		if (lookupProviders) {
			Unique = findProviders();
		}
		if (Unique == null) {
			Unique = new NullPlatformImageFactory();
		}
	}

	public static boolean isLookupProviders() {
		return lookupProviders;
	}

	/**
	 * Set the unique factory.
	 * 
	 * @param unique
	 *            The new unique factory.
	 */
	static public void set(IPlatformImageFactory unique) {
		Unique = unique;
	}

	public static void setLookupProviders(boolean pLookupProviders) {
		lookupProviders = pLookupProviders;
	}
}
