/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.pd.PDImage;
import de.intarsys.tools.attribute.Attribute;

/**
 * 
 */
public class CwtPlatformImageFactory implements IPlatformImageFactory {

	private static final Attribute ATTR_PLATFORMIMAGE = new Attribute(
			"platformImage");

	synchronized public IPlatformImage createPlatformImage(PDImage pdImage) {
		IPlatformImage result = (IPlatformImage) pdImage
				.getAttribute(ATTR_PLATFORMIMAGE);
		if (result == null) {
			result = new CwtPlatformImage(pdImage);
			pdImage.setAttribute(ATTR_PLATFORMIMAGE, result);
		}
		return result;
	}
}
