/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font.type3;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;

public class Type3Glyphs implements IPlatformGlyphs {

	final private Type3Font font;

	final private PDFontType3 pdFont;

	final private PDGlyphs glyphs;

	protected Type3Glyphs(Type3Font font, PDGlyphs glyphs) {
		super();
		this.font = font;
		this.pdFont = (PDFontType3) font.getPDFont();
		this.glyphs = glyphs;
	}

	public PDGlyphs getGlyphs() {
		return glyphs;
	}

	public IPlatformFont getPlatformFont() {
		return font;
	}

	public int getWidth() {
		// not yet implemented
		return 0;
	}

	public void render(ICSPlatformDevice device) {
		GraphicsState graphicsState = device.getGraphicsState();
		COSDictionary charProcs = pdFont.cosGetCharProcs();
		String glyphName = pdFont.getEncoding().getGlyphName(
				glyphs.getCodepoint());
		if (glyphName == null) {
			return;
		}
		COSStream charProc = charProcs.get(COSName.create(glyphName))
				.asStream();
		if (charProc == null) {
			return;
		}
		CSContent charCS = CSContent.createFromCos(charProc);
		device.saveState();
		try {
			TextState textState = graphicsState.textState;
			device.transform(textState.fontSize
					* textState.derivedHorizontalScalingFactor, 0, 0,
					textState.fontSize, 0, 0);
			CDSMatrix m = pdFont.getFontMatrix();
			if (m != null) {
				device.transform(m.getA(), m.getB(), m.getC(), m.getD(), m
						.getE(), m.getF());
			}
			device.getInterpreter().process(charCS, pdFont.getResources());
		} finally {
			device.restoreState();
		}
	}
}
