/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font.type3;

import java.awt.geom.Rectangle2D;

import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;

public class Type3Font implements IPlatformFont {

	private static final Attribute ATTR_PLATFORMGLYPHS = new Attribute(
			"platformGlyphs"); //$NON-NLS-1$

	protected static IPlatformGlyphs lookupPlatformGlyphs(IAttributeSupport as) {
		return (IPlatformGlyphs) as.getAttribute(ATTR_PLATFORMGLYPHS);
	}

	static protected void registerPlatformGlyphs(IAttributeSupport as,
			IPlatformGlyphs object) {
		as.setAttribute(ATTR_PLATFORMGLYPHS, object);
	}

	private PDFont font;

	protected Type3Font(PDFont font) {
		super();
		this.font = font;
	}

	protected IPlatformGlyphs basicCreate(PDGlyphs glyphs) {
		return new Type3Glyphs(this, glyphs);
	}

	synchronized public IPlatformGlyphs createPlatformGlyphs(PDGlyphs glyphs) {
		IPlatformGlyphs result = lookupPlatformGlyphs(glyphs);
		if (result == null) {
			result = basicCreate(glyphs);
			registerPlatformGlyphs(glyphs, result);
		}
		return result;
	}

	public int getAscent() {
		return 0;
	}

	public Rectangle2D getBBox() {
		return new Rectangle2D.Float(0, 0, 0, 0);
	}

	public int getCharIndex(char unicode) {
		return unicode;
	}

	public int getDescent() {
		return 0;
	}

	public int getHeight() {
		return 0;
	}

	public Object getImpl() {
		return getPDFont();
	}

	public PDFont getPDFont() {
		return font;
	}

	public int getUnderlinePosition() {
		return -100;
	}

	public int getUnderlineThickness() {
		return 100;
	}

	public boolean isBoldStyle() {
		return false;
	}

	public boolean isItalicStyle() {
		return false;
	}

	public boolean isMonospaced() {
		return false;
	}

	public boolean isSymbolFont() {
		return false;
	}

	public void saveState(ICSPlatformDevice device, GraphicsState oldState,
			GraphicsState newState) {
		// 
	}

	public void textStateChanged(ICSPlatformDevice device) {
		//
	}

}
