/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.pdf.font.outlet.FontFactory;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.font.outlet.IFontOutlet;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.attribute.Attribute;

/**
 * The standard outlet for {@link PDDocument} specific {@link IFontFactory}
 * instances.
 * 
 */
public class StandardFontOutlet implements IFontOutlet {

	private static final Attribute ATTR_FONTFACTORY = new Attribute(
			"fontfactory");

	synchronized public IFontFactory lookupFontFactory(PDDocument doc) {
		if (doc == null) {
			return FontFactory.get();
		}
		DocumentFontFactory factory = (DocumentFontFactory) doc
				.getAttribute(ATTR_FONTFACTORY);
		if (factory == null) {
			factory = new DocumentFontFactory(doc);
			doc.setAttribute(ATTR_FONTFACTORY, factory);
		}
		return factory;
	}
}
