/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font;

import java.io.IOException;

import de.intarsys.cwt.font.IFont;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.tools.locator.ILocator;

/**
 * A converter from a Type1 font program to a PDF font.
 */
public class FontConverterType12Pdf extends FontConverterPlatform2Pdf {

	public FontConverterType12Pdf(IFont font) {
		super(font);
	}

	@Override
	protected PDFont basicCreatePdFont() {
		return (PDFontType1) PDFontType1.META.createNew();
	}

	@Override
	protected void embedFontFile(ILocator locator)
			throws FontFactoryException {
		try {
			PDFontType1Tools.embedFontFile(getPdFont(), locator);
		} catch (IOException e) {
			throw new FontFactoryException(e);
		}
	}

}
