/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.swt;

import java.awt.color.ColorSpace;

import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;

/**
 * 
 */
public class SwtCSIndexed extends SwtCSSpecial {

	public SwtCSIndexed(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	protected RGB[] extractRGBs() {
		if (myPDColorSpace().getBaseColorSpace() instanceof PDCSDeviceRGB) {
			return extractRGBsDirect();
		}
		return extractRGBsOther();
	}

	protected RGB[] extractRGBsDirect() {
		RGB[] rgbs;

		rgbs = new RGB[myPDColorSpace().getColorCount()];
		for (int index = 0; index < rgbs.length; index++) {
			rgbs[index] = new RGB(
					myPDColorSpace().getColorBytes()[index * 3] & 0xff,
					myPDColorSpace().getColorBytes()[(index * 3) + 1] & 0xff,
					myPDColorSpace().getColorBytes()[(index * 3) + 2] & 0xff);
		}
		return rgbs;
	}

	protected RGB[] extractRGBsOther() {
		ColorSpace colorSpace;
		int numComponents;
		RGB[] rgbs;

		PDColorSpace pdBaseColorSpace = myPDColorSpace().getBaseColorSpace();
		colorSpace = AwtColorSpaceFactory.get().createColorSpace(
				pdBaseColorSpace).getColorSpace();
		numComponents = colorSpace.getNumComponents();
		rgbs = new RGB[myPDColorSpace().getColorCount()];
		for (int index = 0; index < rgbs.length; index++) {
			float[] input;
			float[] output;

			input = new float[numComponents];
			for (int component = 0; component < numComponents; component++) {
				input[component] = ((float) (0xFF & myPDColorSpace()
						.getColorBytes()[index * numComponents + component])) / 255;
			}
			output = colorSpace.toRGB(input);
			rgbs[index] = new RGB((int) (output[0] * 255),
					(int) (output[1] * 255), (int) (output[2] * 255));
		}

		return rgbs;
	}

	@Override
	public int getNumComponents() {
		return 1;
	}

	@Override
	public PaletteData getPalette(PDImage pdImage) {
		return new PaletteData(extractRGBs());
	}

	protected PDCSIndexed myPDColorSpace() {
		return (PDCSIndexed) getPDColorSpace();
	}
}
