/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.swt;

import java.awt.color.ICC_Profile;

import org.eclipse.swt.graphics.PaletteData;

import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class SwtCSICCBased extends SwtCSCIEBased {

	private ICC_Profile iccProfile;

	public SwtCSICCBased(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	protected ICC_Profile getIccProfile() {
		if (iccProfile == null) {
			try {
				iccProfile = ICC_Profile.getInstance(myPDColorSpace()
						.cosGetProfileStream().getDecodedBytes());
			} catch (IllegalArgumentException ex) {
				//
			}
		}
		return iccProfile;
	}

	@Override
	public int getNumComponents() {
		if (getIccProfile() != null) {
			return getIccProfile().getNumComponents();
		}
		return 0;
	}

	@Override
	public PaletteData getPalette(PDImage pdImage) {
		throw new UnsupportedOperationException();
	}

	protected PDCSICCBased myPDColorSpace() {
		return (PDCSICCBased) getPDColorSpace();
	}

}
