/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;

import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSIndexed extends AwtCSSpecial {
	public AwtCSIndexed(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		throw new UnsupportedOperationException();
	}

	protected int[] extractIntRGBS(int colors) {
		if (myPDColorSpace().getBaseColorSpace() instanceof PDCSDeviceRGB) {
			return extractIntRGBsDirect(colors);
		}
		return extractIntRGBsOther(colors);
	}

	protected int[] extractIntRGBsDirect(int colors) {
		int[] rgbs;

		rgbs = new int[colors];
		for (int index = 0; index < colors; index++) {
			rgbs[index] = 0xff000000
					| ((myPDColorSpace().getColorBytes()[index * 3] << 16) & 0x00ff0000)
					| ((myPDColorSpace().getColorBytes()[(index * 3) + 1] << 8) & 0x0000ff00)
					| (myPDColorSpace().getColorBytes()[(index * 3) + 2] & 0x000000ff);
		}
		return rgbs;
	}

	protected int[] extractIntRGBsOther(int colors) {
		ColorSpace colorSpace;
		int numComponents;
		int[] rgbs;

		colorSpace = getColorSpace(myPDColorSpace().getBaseColorSpace())
				.getColorSpace();
		numComponents = colorSpace.getNumComponents();
		rgbs = new int[colors];
		for (int index = 0; index < colors; index++) {
			float[] input;
			float[] output;

			input = new float[numComponents];
			for (int component = 0; component < numComponents; component++) {
				input[component] = ((float) (0xFF & myPDColorSpace()
						.getColorBytes()[index * numComponents + component])) / 255;
			}
			output = colorSpace.toRGB(input);
			rgbs[index] = 0xff000000 | (((int) (output[0] * 255)) << 16)
					| ((((int) (output[1] * 255)) << 8) & 0x0000ff00)
					| (((int) (output[2] * 255)) & 0x000000ff);
		}

		return rgbs;
	}

	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		// WORKAROUND there is a bug in IndexColorModel that rejects combining
		// an IndexColorModel with a Raster that requires FEWER colors than
		// available. So we reduce the Palette here...
		int bits = pdImage.getBitsPerComponent();
		int colors = 1 << bits;
		if (myPDColorSpace().getColorCount() < colors) {
			colors = myPDColorSpace().getColorCount();
		}
		return new IndexColorModel(bits, colors, extractIntRGBS(colors), 0,
				false, -1, DataBuffer.TYPE_BYTE);
	}

	@Override
	public int getNumComponents() {
		return 1;
	}

	@Override
	public float[] getRGB(float[] values) {
		float[] colorValues;

		colorValues = new float[getColorSpace(
				myPDColorSpace().getBaseColorSpace()).getNumComponents()];
		for (int index = 0; index < colorValues.length; index++) {
			colorValues[index] = (myPDColorSpace().getColorBytes()[((int) values[0] * getColorSpace(
					myPDColorSpace().getBaseColorSpace()).getNumComponents())
					+ index] & 0xFF) / 255f;
		}
		return getColorSpace(myPDColorSpace().getBaseColorSpace()).getRGB(
				colorValues);
	}

	protected PDCSIndexed myPDColorSpace() {
		return (PDCSIndexed) getPDColorSpace();
	}
}
