/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorRegistry;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;

public class ProcessingDecorator
implements IStringEvaluator {
    public static final char PROCESSING_SEPARATOR = ':';
    public static final String ARG_SEPARATOR = ",";
    public static final char CLOSE_BRACE = ')';
    public static final char OPEN_BRACE = '(';
    public static final char CODE_REFLECTION = '.';
    public static final char CODE_FUNCTOR = '#';
    public static final char CODE_DEEPRECURSION = '*';
    public static final char CODE_SHALLOWRECURSION = '+';
    public static final char CODE_CONDITIONAL = '?';
    private static IFunctorRegistry formattingFunctors;
    private IStringEvaluator evaluator;
    private char separator = (char)58;
    private String separatorString = "" + this.separator;
    private IStringEvaluator recursionEvaluator;
    private static final String ARG_RECURSION = "de.intarsys.tools.expression.ProcessingDecorator.recursion";

    protected static Object formatFunctor(Object object, String string) throws FunctorInvocationException {
        IFunctorRegistry iFunctorRegistry = ProcessingDecorator.getFormattingFunctors();
        if (iFunctorRegistry == null) {
            return object;
        }
        int n = string.indexOf(40);
        if (n == -1) {
            n = string.length();
        }
        int n2 = string.indexOf(41);
        String string2 = string.substring(0, n);
        String[] stringArray = n < n2 ? string.substring(n + 1, n2).split(ARG_SEPARATOR) : new String[]{};
        IFunctor iFunctor = iFunctorRegistry.lookupFunctor(string2);
        if (iFunctor == null) {
            throw new FunctorInvocationException("formatter '" + string2 + "' not found");
        }
        Args args = Args.createIndexed(object, stringArray);
        FunctorCall functorCall = new FunctorCall(object, args);
        return iFunctor.perform(functorCall);
    }

    public static IFunctorRegistry getFormattingFunctors() {
        return formattingFunctors;
    }

    public static void setFormattingFunctors(IFunctorRegistry iFunctorRegistry) {
        formattingFunctors = iFunctorRegistry;
    }

    public ProcessingDecorator(IStringEvaluator iStringEvaluator) {
        this.evaluator = iStringEvaluator;
        this.recursionEvaluator = iStringEvaluator;
    }

    @Override
    public Object evaluate(String string, IArgs iArgs) throws EvaluationException {
        Object object;
        String[] stringArray = string.split(this.getSeparatorString(), -1);
        String string2 = stringArray[0].trim();
        if (string2.startsWith("\"")) {
            try {
                object = StringTools.unquote(string2);
            }
            catch (IOException iOException) {
                throw new EvaluationException(iOException);
            }
        } else {
            object = this.evaluator.evaluate(string2, iArgs);
        }
        int n = 1;
        while (n < stringArray.length) {
            object = this.evaluateInstruction(object, iArgs, stringArray[n]);
            ++n;
        }
        return object;
    }

    protected Object evaluateConditional(Object object, IArgs iArgs, String string) throws EvaluationException {
        String string2 = string.trim().substring(1);
        boolean bl = ArgTools.getBool(iArgs, string2, false);
        return bl ? object : null;
    }

    protected Object evaluateDeepRecursion(Object object, IArgs iArgs, String string) throws EvaluationException {
        int n = (Integer)iArgs.get(ARG_RECURSION, (Object)10);
        if (n == -1) {
            throw new EvaluationException("expression nested to deeply");
        }
        iArgs.put(ARG_RECURSION, (Object)(--n));
        return this.recursionEvaluator.evaluate(String.valueOf(object), iArgs);
    }

    protected Object evaluateFunctor(Object object, IArgs iArgs, String string) throws EvaluationException {
        try {
            return ProcessingDecorator.formatFunctor(object, string.substring(1));
        }
        catch (FunctorInvocationException functorInvocationException) {
            throw new EvaluationException(functorInvocationException.getCause() == null ? functorInvocationException : functorInvocationException.getCause());
        }
    }

    protected Object evaluateInstruction(Object object, IArgs iArgs, String string) throws EvaluationException {
        if (string.length() == 0) {
            return StringTools.format(object, string);
        }
        if (string.charAt(0) == '+') {
            return this.evaluateDeepRecursion(object, iArgs, string);
        }
        if (string.charAt(0) == '*') {
            return this.evaluateDeepRecursion(object, iArgs, string);
        }
        if (string.charAt(0) == '#') {
            return this.evaluateFunctor(object, iArgs, string);
        }
        if (string.charAt(0) == '?') {
            return this.evaluateConditional(object, iArgs, string);
        }
        if (string.charAt(0) == '.') {
            return this.evaluateReflection(object, iArgs, string);
        }
        return StringTools.format(object, string);
    }

    protected Object evaluateReflection(Object object, IArgs iArgs, String string) throws EvaluationException {
        ReflectiveResolver reflectiveResolver = new ReflectiveResolver(object);
        return reflectiveResolver.evaluate(string, iArgs);
    }

    protected Object evaluateShallowRecursion(Object object, IArgs iArgs, String string) throws EvaluationException {
        int n = (Integer)iArgs.get(ARG_RECURSION, (Object)1);
        if (n == -1) {
            throw new EvaluationException("expression nested to deeply");
        }
        iArgs.put(ARG_RECURSION, (Object)n--);
        return this.recursionEvaluator.evaluate(String.valueOf(object), iArgs);
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public IStringEvaluator getRecursionEvaluator() {
        return this.recursionEvaluator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSeparatorString() {
        return this.separatorString;
    }

    public void setRecursionEvaluator(IStringEvaluator iStringEvaluator) {
        this.recursionEvaluator = iStringEvaluator;
    }

    public void setSeparator(char c) {
        this.separator = c;
    }
}

