/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.adapter.AdapterOutlet;
import de.intarsys.tools.expression.ArrayResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorSupport;
import de.intarsys.tools.expression.ListResolver;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.StaticArgsResolver;
import de.intarsys.tools.expression.VariableNamespaceResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.variable.IVariableNamespace;
import java.util.List;
import java.util.Map;

public abstract class ContainerResolver
implements IStringEvaluator {
    private IStringEvaluator exceptionResolver;
    private final char separator;

    public ContainerResolver() {
        this('.');
    }

    public ContainerResolver(char c) {
        this.separator = c;
    }

    protected abstract Object basicEvaluate(String var1, IArgs var2) throws EvaluationException;

    protected IStringEvaluator createResolver(Object object) {
        if (object instanceof IStringEvaluator) {
            return (IStringEvaluator)object;
        }
        if (object instanceof IStringEvaluatorSupport) {
            return ((IStringEvaluatorSupport)object).getStringEvaluator();
        }
        if (object instanceof Map) {
            return new MapResolver((Map)object, false);
        }
        if (object instanceof List) {
            return new ListResolver((List)object);
        }
        if (object instanceof IArgs) {
            return new StaticArgsResolver((IArgs)object);
        }
        if (object instanceof IVariableNamespace) {
            return new VariableNamespaceResolver((IVariableNamespace)object);
        }
        if (object instanceof Object[]) {
            return new ArrayResolver((Object[])object);
        }
        if (object == null) {
            return null;
        }
        IStringEvaluator iStringEvaluator = AdapterOutlet.get().getAdapter(object, IStringEvaluator.class);
        if (iStringEvaluator == null) {
            return new ReflectiveResolver(object);
        }
        return iStringEvaluator;
    }

    @Override
    public final Object evaluate(String string, IArgs iArgs) throws EvaluationException {
        String string2 = string;
        int n = string2.indexOf(this.getSeparator());
        if (n == -1) {
            return this.evaluatePrefix(string2, iArgs);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Object object = this.evaluatePrefix(string3, iArgs);
        IStringEvaluator iStringEvaluator = this.createResolver(object);
        if (iStringEvaluator != null) {
            return iStringEvaluator.evaluate(string4, iArgs);
        }
        throw new EvaluationException("can't evaluate '" + string + "'");
    }

    protected Object evaluatePrefix(String string, IArgs iArgs) throws EvaluationException {
        Object object;
        try {
            object = this.basicEvaluate(string, iArgs);
        }
        catch (EvaluationException evaluationException) {
            if (this.exceptionResolver != null) {
                object = this.exceptionResolver.evaluate(string, iArgs);
            }
            throw evaluationException;
        }
        if (object instanceof IValueHolder) {
            object = ((IValueHolder)object).get();
        }
        return object;
    }

    public IStringEvaluator getExceptionResolver() {
        return this.exceptionResolver;
    }

    public final char getSeparator() {
        return this.separator;
    }

    public void setExceptionResolver(IStringEvaluator iStringEvaluator) {
        this.exceptionResolver = iStringEvaluator;
    }
}

