/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class CryptoEnvironment {
    private static final CryptoEnvironment ACTIVE = new CryptoEnvironment();
    private Map<String, ICryptdec> cryptdecs = new HashMap<String, ICryptdec>();
    private ICryptdec defaultCryptdecEncrypt;
    private ICryptdec defaultCryptdecDecrypt;

    public static CryptoEnvironment get() {
        return ACTIVE;
    }

    private CryptoEnvironment() {
    }

    public byte[] decrypt(byte[] byArray) throws IOException {
        if (this.defaultCryptdecDecrypt == null) {
            throw new IllegalStateException("default cryptdec not defined");
        }
        return this.defaultCryptdecDecrypt.decrypt(byArray);
    }

    public String decryptEncoded(String string) throws IOException {
        return this.decryptEncoded(string, this.defaultCryptdecDecrypt);
    }

    public String decryptEncoded(String string, ICryptdec iCryptdec) throws IOException {
        try {
            String string2;
            ICryptdec iCryptdec2;
            String[] stringArray = string.split("#");
            if (stringArray.length == 1) {
                iCryptdec2 = iCryptdec;
                string2 = stringArray[0];
            } else {
                iCryptdec2 = this.lookupCryptdec(stringArray[0]);
                string2 = stringArray[1];
            }
            if (iCryptdec2 == null) {
                throw new IOException("unknown encryption scheme");
            }
            if (StringTools.isEmpty(string2)) {
                return string2;
            }
            byte[] byArray = Base64.decode(StringTools.toByteArray(string2));
            byte[] byArray2 = iCryptdec2.decrypt(byArray);
            return new String(byArray2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ExceptionTools.createIOException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public String decryptRaw(String string) throws IOException {
        try {
            if (StringTools.isEmpty(string)) {
                return string;
            }
            byte[] byArray = Base64.decode(StringTools.toByteArray(string));
            byte[] byArray2 = this.decrypt(byArray);
            return new String(byArray2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ExceptionTools.createIOException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public byte[] encrypt(byte[] byArray) throws IOException {
        if (this.defaultCryptdecEncrypt == null) {
            throw new IllegalStateException("default cryptdec not defined");
        }
        return this.defaultCryptdecEncrypt.encrypt(byArray);
    }

    public String encryptEncoded(char[] cArray) throws IOException {
        if (this.defaultCryptdecEncrypt == null) {
            throw new IllegalStateException("default cryptdec not defined");
        }
        return this.encryptEncoded(cArray, this.defaultCryptdecEncrypt);
    }

    public String encryptEncoded(char[] cArray, ICryptdec iCryptdec) throws IOException {
        try {
            if (iCryptdec == null) {
                throw new NullPointerException("cryptdec not defined");
            }
            byte[] byArray = new String(cArray).getBytes("UTF8");
            byte[] byArray2 = this.encrypt(byArray);
            return String.valueOf(iCryptdec.getId()) + "#" + new String(Base64.encode(byArray2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ExceptionTools.createIOException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public String encryptEncoded(String string) throws IOException {
        if (this.defaultCryptdecEncrypt == null) {
            throw new IllegalStateException("default cryptdec not defined");
        }
        return this.encryptEncoded(string, this.defaultCryptdecEncrypt);
    }

    public String encryptEncoded(String string, ICryptdec iCryptdec) throws IOException {
        try {
            if (iCryptdec == null) {
                throw new NullPointerException("cryptdec not defined");
            }
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = this.encrypt(byArray);
            return String.valueOf(iCryptdec.getId()) + "#" + new String(Base64.encode(byArray2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ExceptionTools.createIOException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public String encryptRaw(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = this.encrypt(byArray);
            return new String(Base64.encode(byArray2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ExceptionTools.createIOException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public ICryptdec getDefaultCryptdecDecrypt() {
        return this.defaultCryptdecDecrypt;
    }

    public ICryptdec getDefaultCryptdecEncrypt() {
        return this.defaultCryptdecEncrypt;
    }

    public ICryptdec lookupCryptdec(String string) {
        return this.cryptdecs.get(string);
    }

    public void registerCryptdec(ICryptdec iCryptdec) {
        if (this.cryptdecs.containsKey(iCryptdec.getId())) {
            throw new IllegalStateException("can't redefine cryptdecs");
        }
        this.cryptdecs.put(iCryptdec.getId(), iCryptdec);
    }

    public void setDefaultCryptdecDecrypt(ICryptdec iCryptdec) {
        if (this.defaultCryptdecDecrypt != null) {
            throw new IllegalStateException("can't redefine cryptdecs");
        }
        this.defaultCryptdecDecrypt = iCryptdec;
    }

    public void setDefaultCryptdecEncrypt(ICryptdec iCryptdec) {
        if (this.defaultCryptdecEncrypt != null) {
            throw new IllegalStateException("can't redefine cryptdecs");
        }
        this.defaultCryptdecEncrypt = iCryptdec;
    }
}

