/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.api;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeInterface;
import de.intarsys.tools.provider.ProviderTools;
import java.util.Iterator;

public class NativeInterface {
    private static INativeInterface ACTIVE;
    private static String NAME;
    public static INativeHandle NULL;
    public static final String PROP_NATIVEINTERFACE = "de.intarsys.nativec.api.INativeInterface";

    protected static INativeInterface createNativeInterface() {
        String string = NativeInterface.getName();
        if (string == null) {
            string = System.getProperty(PROP_NATIVEINTERFACE);
        }
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                return (INativeInterface)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new NoClassDefFoundError(string);
            }
        }
        return NativeInterface.findNativeInterface();
    }

    protected static INativeInterface findNativeInterface() {
        Iterator iterator = ProviderTools.providers(INativeInterface.class);
        if (iterator.hasNext()) {
            try {
                return (INativeInterface)iterator.next();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized INativeInterface get() {
        if (ACTIVE == null) {
            NativeInterface.set(NativeInterface.createNativeInterface());
        }
        return ACTIVE;
    }

    public static synchronized String getName() {
        return NAME;
    }

    public static synchronized void set(INativeInterface iNativeInterface) {
        if (iNativeInterface == null) {
            throw new NullPointerException("no native interface available");
        }
        ACTIVE = iNativeInterface;
        NULL = iNativeInterface.createHandle(0L);
    }

    public static synchronized void setName(String string) {
        NAME = string;
    }
}

